/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldX;
import org.lsst.ccs.subsystem.refrig.ui.UiConstants;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

public class HeaterPanel
extends JPanel {
    private static final String[] panelNames = new String[2];
    private final int id;
    private final CommandSender sender;
    private final JLabel switchLabel = new JLabel("Heater Power: ");
    private final JLabel switchStatus = new JLabel("OFF");
    private final ButtonGroup switchBG = new ButtonGroup();
    private final JRadioButton switchOffRB = new JRadioButton("Off");
    private final JRadioButton switchOnRB = new JRadioButton("On");
    private final JLabel controlLabel = new JLabel("Heater Control: ");
    private final JLabel controlStatus = new JLabel("OFF");
    private final ButtonGroup controlBG = new ButtonGroup();
    private final JRadioButton controlOffRB = new JRadioButton("Off");
    private final JRadioButton controlManualRB = new JRadioButton("Manual");
    private final JRadioButton controlAutoRB = new JRadioButton("Auto");
    private final JPanel powerPanel = new JPanel();
    private final JTextField powerTextField = new JTextField();
    private final TextFieldX powerTFX = new TextFieldX(this.powerTextField, 2);
    private final JLabel powerUnitsLabel = new JLabel("W");
    private final JPanel tempPanel = new JPanel();
    private final JTextField tempTextField = new JTextField();
    private final TextFieldX tempTFX = new TextFieldX(this.tempTextField, 2);
    private final JLabel tempUnitsLabel = new JLabel("\u00b0C");
    private static final long serialVersionUID = 1L;

    HeaterPanel(int id, CommandSender sender) {
        this.id = id;
        this.sender = sender;
        this.initComponents();
    }

    public void updatePanel(ThermalState rs) {
        this.switchStatus.setEnabled(true);
        this.controlStatus.setEnabled(true);
        int state = rs.getHeaterPowerState(this.id);
        this.switchStatus.setText(state == 1 ? "ON" : (state == 2 ? "TRIPPED" : "OFF"));
        this.switchStatus.setForeground(state == 1 ? UiConstants.GREEN : (state == 2 ? UiConstants.RED : Color.black));
        JRadioButton selButton = state == 1 ? this.switchOnRB : this.switchOffRB;
        selButton.setSelected(true);
        this.switchOffRB.setEnabled(state == 1);
        this.switchOnRB.setEnabled(state == 0);
        state = rs.getHeaterControlState(this.id);
        this.controlStatus.setText(state == 1 ? "MANUAL" : (state == 2 ? "AUTO" : "OFF"));
        this.controlStatus.setForeground(state == 1 ? UiConstants.GREEN : (state == 2 ? UiConstants.RED : Color.black));
        selButton = state == 1 ? this.controlManualRB : (state == 2 ? this.controlAutoRB : this.controlOffRB);
        selButton.setSelected(true);
        this.controlOffRB.setEnabled(selButton != this.controlOffRB);
        this.controlManualRB.setEnabled(selButton != this.controlManualRB);
        this.controlAutoRB.setEnabled(selButton != this.controlAutoRB);
        this.powerTFX.update(rs.getHeaterPower(this.id), true);
        this.tempTFX.update(rs.getPlateTemp(this.id), true);
    }

    public void disablePanel() {
        this.switchStatus.setEnabled(false);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.controlStatus.setEnabled(false);
        this.controlOffRB.setEnabled(false);
        this.controlManualRB.setEnabled(false);
        this.controlAutoRB.setEnabled(false);
        this.powerTFX.disable();
        this.tempTFX.disable();
    }

    private void initComponents() {
        this.switchLabel.setFont(UiConstants.FONT);
        this.switchStatus.setFont(UiConstants.FONT);
        this.switchOffRB.setFont(UiConstants.FONT);
        this.switchOffRB.setFocusable(false);
        this.switchOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeaterPanel.this.setHeaterPowerState(0);
            }
        });
        this.switchOnRB.setFont(UiConstants.FONT);
        this.switchOnRB.setFocusable(false);
        this.switchOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeaterPanel.this.setHeaterPowerState(1);
            }
        });
        this.switchBG.add(this.switchOffRB);
        this.switchBG.add(this.switchOnRB);
        this.controlLabel.setFont(UiConstants.FONT);
        this.controlStatus.setFont(UiConstants.FONT);
        Dimension d = this.controlStatus.getPreferredSize();
        d.width = 60;
        this.controlStatus.setMinimumSize(d);
        this.controlStatus.setPreferredSize(d);
        this.controlOffRB.setFont(UiConstants.FONT);
        this.controlOffRB.setFocusable(false);
        this.controlOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeaterPanel.this.setHeaterControlState(0);
            }
        });
        this.controlManualRB.setFont(UiConstants.FONT);
        this.controlManualRB.setFocusable(false);
        this.controlManualRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeaterPanel.this.setHeaterControlState(1);
            }
        });
        this.controlAutoRB.setFont(UiConstants.FONT);
        this.controlAutoRB.setFocusable(false);
        this.controlAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeaterPanel.this.setHeaterControlState(-1);
            }
        });
        this.controlBG.add(this.controlOffRB);
        this.controlBG.add(this.controlManualRB);
        this.controlBG.add(this.controlAutoRB);
        d = this.powerTextField.getPreferredSize();
        d.width = 50;
        this.powerTextField.setMinimumSize(d);
        this.powerTextField.setPreferredSize(d);
        this.powerTextField.setHorizontalAlignment(0);
        this.powerTextField.setText("...");
        this.powerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HeaterPanel.this.powerTFX.focusLost();
            }
        });
        this.powerTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)HeaterPanel.this.powerTFX.action();
                if (value != null) {
                    HeaterPanel.this.sender.sendCommand(null, "setHeaterPower", HeaterPanel.this.id, value);
                }
            }
        });
        this.powerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                HeaterPanel.this.powerTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.powerUnitsLabel.setFont(UiConstants.FONT);
        d = this.tempTextField.getPreferredSize();
        d.width = 60;
        this.tempTextField.setMinimumSize(d);
        this.tempTextField.setPreferredSize(d);
        this.tempTextField.setHorizontalAlignment(0);
        this.tempTextField.setText("...");
        this.tempTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HeaterPanel.this.tempTFX.focusLost();
            }
        });
        this.tempTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)HeaterPanel.this.tempTFX.action();
                if (value != null) {
                    HeaterPanel.this.sender.sendCommand(null, "setLoadTemp", HeaterPanel.this.id, value);
                }
            }
        });
        this.tempTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                HeaterPanel.this.tempTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.tempUnitsLabel.setFont(UiConstants.FONT);
        TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), panelNames[this.id]);
        border.setTitleColor(UiConstants.BLUE);
        border.setTitleJustification(2);
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets.top = 5;
        this.add((Component)this.switchLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchStatus, gbc);
        ++gbc.gridx;
        gbc.insets.top = 1;
        this.add((Component)this.switchOffRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchOnRB, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.top = 0;
        this.add((Component)this.controlLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlStatus, gbc);
        ++gbc.gridx;
        gbc.insets.top = -4;
        this.add((Component)this.controlOffRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlManualRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlAutoRB, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridx = 3;
        this.powerPanel.add(this.powerTextField);
        this.powerPanel.add(this.powerUnitsLabel);
        this.add((Component)this.powerPanel, gbc);
        ++gbc.gridx;
        this.tempPanel.add(this.tempTextField);
        this.tempPanel.add(this.tempUnitsLabel);
        this.add((Component)this.tempPanel, gbc);
    }

    private void setHeaterPowerState(int value) {
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.sender.sendCommand(null, "setHeaterPowerEnable", this.id, value);
    }

    private void setHeaterControlState(int value) {
        this.controlOffRB.setEnabled(false);
        this.controlManualRB.setEnabled(false);
        this.controlAutoRB.setEnabled(false);
        this.sender.sendCommand(null, "setHeaterControl", this.id, value);
    }

    static {
        HeaterPanel.panelNames[0] = "Cold plate control";
        HeaterPanel.panelNames[1] = "Cryo plate control";
    }
}

