/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.config.NamesAndTag;

public class ConfigUtils {
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";

    private ConfigUtils() {
    }

    public static NamesAndTag namesFromPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        String cat = "";
        if (ConfigUtils.isAPath(pathName)) {
            int indexDot = pathName.lastIndexOf(46);
            int lastPath = pathName.lastIndexOf(47);
            String rawName = pathName.substring(lastPath + 1, indexDot);
            String[] elements = rawName.split("_");
            switch (elements.length) {
                case 3: {
                    configName = elements[2] + ":";
                    cat = elements[2];
                }
                case 2: {
                    configName = configName + elements[1];
                }
                case 1: {
                    tag = elements[0];
                }
            }
        } else {
            configName = pathName;
        }
        return new NamesAndTag(subsystemName, configName, tag, cat);
    }

    private static boolean isAPath(String string) {
        int lastPath;
        if (string == null) {
            return false;
        }
        int lastDot = string.lastIndexOf(46);
        return lastDot > (lastPath = string.lastIndexOf(47));
    }

    public static Map<String, String> rawParseConfigurationString(String ... configNames) {
        return ConfigUtils.parseConfigurationString(null, configNames);
    }

    public static Map<String, String> parseConfigurationString(Set<String> categorySet, String ... configNames) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : configNames) {
            if (s.isEmpty()) {
                res.put("", "");
                continue;
            }
            if (!s.contains(":")) {
                res.put("", s);
                continue;
            }
            String[] keyVal = s.split(":", -1);
            if (keyVal.length != 2) {
                throw new IllegalArgumentException("configuration " + keyVal.length);
            }
            if (categorySet != null && !categorySet.contains(keyVal[0])) {
                throw new IllegalArgumentException("unexisting category " + keyVal[0]);
            }
            res.put(keyVal[0], keyVal[1]);
        }
        return res;
    }

    public static Map<String, String> parseConfigurationStringWithDefaults(Set<String> categories, String ... taggedCategories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String cat : categories) {
            res.put(cat, "");
        }
        res.putAll(ConfigUtils.parseConfigurationString(categories, taggedCategories));
        return res;
    }

    public static Set<String> parseCategories(Set<String> categorySet, String ... categories) {
        HashSet<String> res = new HashSet<String>();
        for (String cat : categories) {
            if (!categorySet.contains(cat)) {
                throw new IllegalArgumentException("unexisting category " + cat);
            }
            res.add(cat);
        }
        return res;
    }
}

