/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.BulkSettingException;
import org.lsst.ccs.utilities.constraints.Constraints;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ViewValue;

public abstract class ParameterSetter<T> {
    T targetComponent;
    final Map<String, ViewValue> submittedChanges = new HashMap<String, ViewValue>();
    private final Map<String, Method> configChangerMap;
    private final Map<String, Field> fieldsMap;
    private final Map<String, String> constraintsMap = new HashMap<String, String>();
    private final Map<String, Type> typeMap = new HashMap<String, Type>();
    private final Map<String, Boolean> isFinalMap = new HashMap<String, Boolean>();

    public ParameterSetter(Map<String, Method> configChangerMap, Map<String, Field> fieldsMap) {
        this.configChangerMap = configChangerMap;
        this.fieldsMap = fieldsMap;
        for (Map.Entry<String, Field> entry : fieldsMap.entrySet()) {
            String parmName = entry.getKey();
            Field field = entry.getValue();
            this.typeMap.put(parmName, field.getGenericType());
            this.isFinalMap.put(parmName, field.getAnnotation(ConfigurationParameter.class).isFinal());
            this.constraintsMap.put(parmName, field.getAnnotation(ConfigurationParameter.class).range());
        }
    }

    public void submitChange(String parameterName, Object value) {
        String strValue = TypeUtils.stringify((Object)value);
        ViewValue viewValue = this.convert(parameterName, strValue);
        this.submittedChanges.put(parameterName, viewValue);
    }

    public void dropSubmittedChanges() {
        this.submittedChanges.clear();
    }

    public boolean hasSubmittedChanges() {
        return !this.submittedChanges.isEmpty();
    }

    public void invokeValidateBulkChange(Map<String, String> others, boolean checkFinal) {
        this.invokeValidateBulkChangeInternal(this.submittedChanges, others, checkFinal);
    }

    abstract void invokeValidateBulkChangeInternal(Map<String, ViewValue> var1, Map<String, String> var2, boolean var3);

    abstract Set<String> invokeSetBulkParameters(Map<String, Object> var1);

    private void invokeSetParameter(String parameterName, Object arg) throws IllegalAccessException, InvocationTargetException {
        Method m = this.configChangerMap.get(parameterName);
        if (m != null) {
            m.invoke(this.targetComponent, arg);
        } else {
            Field f = this.fieldsMap.get(parameterName);
            if (f != null) {
                f.setAccessible(true);
                f.set(this.targetComponent, arg);
            } else {
                throw new IllegalArgumentException("no such config property : " + parameterName);
            }
        }
    }

    public void invokeSetSingleParameter(String parameterName, Object value, Map<String, String> currentView, boolean checkFinal) {
        HashMap<String, String> changeAsMap = new HashMap<String, String>();
        changeAsMap.put(parameterName, TypeUtils.stringify((Object)value));
        Map<String, ViewValue> res = this.convert(changeAsMap);
        this.invokeValidateBulkChangeInternal(res, currentView, checkFinal);
        this.invokeSetParametersInternal(res);
    }

    public Map<String, String> invokeSetParameters() throws BulkSettingException {
        try {
            Map<String, String> processedParms = this.invokeSetParametersInternal(this.submittedChanges);
            this.dropSubmittedChanges();
            return processedParms;
        }
        catch (BulkSettingException ex) {
            this.dropSubmittedChanges();
            throw ex;
        }
    }

    private Map<String, String> invokeSetParametersInternal(Map<String, ViewValue> validatedChanges) throws BulkSettingException {
        HashMap<String, String> processedParms = new HashMap<String, String>();
        HashSet<String> remainingParms = new HashSet<String>();
        try {
            remainingParms.addAll(this.invokeSetBulkParameters(validatedChanges.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ViewValue)entry.getValue()).getValue()))));
            for (String parmName : validatedChanges.keySet()) {
                if (remainingParms.contains(parmName)) continue;
                processedParms.put(parmName, validatedChanges.get(parmName).getView());
            }
        }
        catch (Exception ex) {
            throw new BulkSettingException(Collections.EMPTY_MAP, true, ex);
        }
        for (String parmName : remainingParms) {
            try {
                this.invokeSetParameter(parmName, validatedChanges.get(parmName).getValue());
                processedParms.put(parmName, validatedChanges.get(parmName).getView());
            }
            catch (Exception ex) {
                throw new BulkSettingException("error invoking setter method for parameter : " + parmName, processedParms, false, ex);
            }
        }
        return processedParms;
    }

    public Map<String, Field> getParameterFields() {
        return Collections.unmodifiableMap(this.fieldsMap);
    }

    public void setTarget(T target) {
        this.targetComponent = target;
    }

    public void addConstraint(String parmName, String constraint) {
        if (!constraint.isEmpty()) {
            this.constraintsMap.put(parmName, constraint);
        }
    }

    public void addTypeForParm(String parmName, Type type) {
        this.typeMap.put(parmName, type);
    }

    protected void checkAgainstConstraints(Map<String, ViewValue> parms, boolean checkFinal) {
        parms.entrySet().stream().forEach(entry -> {
            String parmName = (String)entry.getKey();
            if (checkFinal && this.isFinalMap.get(entry.getKey()).booleanValue()) {
                throw new IllegalStateException(" parameter " + parmName + " not modifiable at runtime");
            }
            Object val = ((ViewValue)entry.getValue()).getValue();
            String constraint = this.constraintsMap.get(parmName);
            if (constraint != null) {
                Constraints.check((Object)val, (String)constraint);
            }
        });
    }

    protected Map<String, ViewValue> convert(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            try {
                return this.convert((String)entry.getKey(), (String)entry.getValue());
            }
            catch (TypeConversionException ex) {
                throw new IllegalArgumentException("failure converting : " + (String)entry.getKey() + " with value " + (String)entry.getValue() + " to type " + this.typeMap.get(entry.getKey()).getTypeName(), ex);
            }
        }));
    }

    private ViewValue convert(String parameterName, String strValue) throws TypeConversionException {
        new InputConversionEngine();
        Object val = InputConversionEngine.convertArgToType((String)strValue, (Type)this.typeMap.get(parameterName));
        return new ViewValue(strValue, val);
    }

    public void addFinalPropForParm(String parmName, boolean isFinal) {
        this.isFinalMap.put(parmName, isFinal);
    }

    public Type getTypeForParm(String parameterName) {
        return this.typeMap.get(parameterName);
    }

    public String getConstraintFor(String parmName) {
        return this.constraintsMap.get(parmName);
    }

    public static <A, B, C> Function<A, C> compose(Function<A, B> f1, Function<B, C> f2) {
        return f1.andThen(f2);
    }

    public Map<String, String> getSubmittedChanges() {
        return Collections.unmodifiableMap(this.submittedChanges.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ParameterSetter.compose(Map.Entry::getValue, ViewValue::getView))));
    }
}

