/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;

public class ChannelDropHandler
implements PlotRegionDropHandler {
    private final LsstTrendingPlugin plugin;
    private PlotRegion region;

    public ChannelDropHandler(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setPlotRegion(PlotRegion region) {
        this.region = region;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.region == null) {
            return;
        }
        Transferable trans = dtde.getTransferable();
        TrendingChannel channel = null;
        for (DataFlavor flavor : trans.getTransferDataFlavors()) {
            Class<?> k = flavor.getRepresentationClass();
            if (!TrendingChannel.class.isAssignableFrom(k)) continue;
            try {
                channel = (TrendingChannel)trans.getTransferData(flavor);
                break;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        if (channel != null) {
            if (this.plugin.getPreferences().getDnd() == 1) {
                this.plugin.plot(channel, null, this.region, TrendPlotter.Option.OVERLAY);
            } else {
                this.plugin.plot(channel, null, this.region, new TrendPlotter.Option[0]);
            }
        } else {
            dtde.rejectDrop();
        }
        dtde.dropComplete(true);
    }
}

