/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class SubscaleTable
extends JPanel {
    static final String[] colNames = new String[]{"Description", "C1 Value", "C2 Value", "Units", "Low Limit", "Al.", "High Limit", "Al.", "Name"};
    static final Class[] colTypes = new Class[]{String.class, TrendingValue.class, TrendingValue.class, String.class, Double.class, AlarmMarker.class, Double.class, AlarmMarker.class, String.class};
    static final Color colGood = new Color(160, 255, 160);
    static final Color colWarn = new Color(255, 255, 100);
    static final Color colError = new Color(255, 160, 160);
    static final Color colOffln = new Color(160, 200, 255);
    static final Color colPopup = new Color(255, 255, 160);
    static final Font myFont = new Font("Helvetica", 0, 12);
    static final Font changeFont = new Font("Helvetica", 1, 12);
    static final int DESCRIPTION_IND = 0;
    static final int VALUE1_IND = 1;
    static final int VALUE2_IND = 2;
    static final int UNITS_IND = 3;
    static final int LOW_LIMIT_IND = 4;
    static final int LOW_ALARM_IND = 5;
    static final int HIGH_LIMIT_IND = 6;
    static final int HIGH_ALARM_IND = 7;
    static final int NAME_IND = 8;
    private final JTabbedPane tabs = new JTabbedPane();
    private final Map<String, SubsysDesc> subsysMap = new HashMap<String, SubsysDesc>();
    private final List<String[]> tableDesc = new ArrayList<String[]>();
    private final CommandSender sender;
    private Popup popup;
    private static final long serialVersionUID = 1L;

    public SubscaleTable(CommandSender sender) {
        this.sender = sender;
        this.setLayout(new BoxLayout(this, 2));
        this.initTableDesc();
    }

    private void initTableDesc() {
        this.tableDesc.add(new String[]{"Compressor"});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"Heat Exchanger"});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"C1.", "C2."});
        this.tableDesc.add(new String[]{"Cryostat"});
        this.tableDesc.add(new String[]{"", ""});
        this.tableDesc.add(new String[]{"", ""});
        this.tableDesc.add(new String[]{"", ""});
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        TrendingTable table = (TrendingTable)evt.getSource();
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        if (table.sDesc == null) {
            return;
        }
        if (evt.getClickCount() == 1) {
            int column = table.columnAtPoint(point);
            if (column != 5 && column != 7) {
                return;
            }
            String name = (String)table.getValueAt(row, column);
            if (name == null || name.length() == 0) {
                return;
            }
            PopupFactory fact = PopupFactory.getSharedInstance();
            this.popup = fact.getPopup(null, table.sDesc.alarmMap.get(name), evt.getXOnScreen(), evt.getYOnScreen());
            this.popup.show();
        } else if (evt.getClickCount() == 2) {
            String name = (String)table.getValueAt(row, 8);
            if (name.length() == 0) {
                return;
            }
            String[] path = new String[]{table.sDesc.name, name};
            Studio studio = (Studio)Studio.getApplication();
            if (studio == null) {
                return;
            }
            TrendingService trending = (TrendingService)studio.getLookup().lookup(TrendingService.class);
            if (trending == null) {
                return;
            }
            trending.show(path);
        }
    }

    public void setSubsystems(String ... sNames) {
        for (String sName : sNames) {
            SubsysDesc sDesc = new SubsysDesc();
            sDesc.name = sName;
            sDesc.table = new TrendingTable();
            sDesc.table.initialize(sDesc, sName);
            TrendingTableModel model = sDesc.table.model();
            for (String[] desc : this.tableDesc) {
                if (desc.length == 1) {
                    model.addRow(new Object[]{desc[0], null, null, "", null, "", null, "", ""});
                    sDesc.table.tsRowMap.add(-1);
                    continue;
                }
                ChanDesc cDesc = new ChanDesc();
                cDesc.tRow = sDesc.table.tsRowMap.size();
                cDesc.tCol = 1;
                sDesc.chanMap.put(desc[0], cDesc);
                if (!desc[1].isEmpty()) {
                    cDesc = new ChanDesc();
                    cDesc.tRow = sDesc.table.tsRowMap.size();
                    cDesc.tCol = 2;
                    sDesc.chanMap.put(desc[1], cDesc);
                }
                model.addRow(new Object[]{"", 0, 0, "", 0, "", 0, "", ""});
            }
            this.subsysMap.put(sName, sDesc);
        }
    }

    public void updateTableModel(String sName, MonitorFullState status) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(sDesc, status));
    }

    public void updateTableValue(String sName, String cName, double value) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTableValue(sDesc, cName, value));
    }

    public void updateTableLimit(String sName, String cName, String limName, String value) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateLimitValue(sDesc, cName, limName, value));
    }

    public void updateTableState(String sName, MonitorState status) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateState(sDesc, status));
    }

    public void disableSystem(String sName) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new DisableSystem(sDesc));
    }

    void updateState(SubsysDesc sDesc, MonitorState s) {
        BitSet updateValue = (BitSet)s.getGoodChans().clone();
        updateValue.xor(sDesc.goodChans);
        sDesc.goodChans.xor(updateValue);
        BitSet updateOnline = (BitSet)s.getOnlineChans().clone();
        updateOnline.xor(sDesc.onlineChans);
        sDesc.onlineChans.xor(updateOnline);
        if (!sDesc.channels.isEmpty()) {
            updateValue.or(updateOnline);
            int sRow = updateValue.nextSetBit(0);
            while (sRow >= 0) {
                ChanDesc cDesc = sDesc.channels.get(sRow);
                if (cDesc != null) {
                    TrendingTable table = sDesc.table;
                    table.setValueAt(table.getValueAt(cDesc.tRow, cDesc.tCol), cDesc.tRow, cDesc.tCol);
                }
                sRow = updateValue.nextSetBit(sRow + 1);
            }
        }
    }

    void addTrendingRow(SubsysDesc sDesc, MonitorChan chan) {
        ChanDesc cDesc = sDesc.chanMap.get(chan.getName());
        if (cDesc != null) {
            TrendingTable table = sDesc.table;
            TrendingTableModel model = table.model();
            String[] descrip = chan.getDescription().split("\\\\", 2);
            if (descrip.length == 2) {
                descrip[0] = descrip[1];
            }
            cDesc.sRow = sDesc.channels.size();
            if (cDesc.tCol == 1) {
                table.tsRowMap.add(cDesc.sRow);
                model.setValueAt("  " + descrip[0], cDesc.tRow, 0);
                model.setValueAt(chan.getValue(), cDesc.tRow, 1);
                model.setValueAt(chan.getUnits(), cDesc.tRow, 3);
                model.setValueAt(chan.getLowLimit(), cDesc.tRow, 4);
                model.setValueAt(chan.getLowAlarm(), cDesc.tRow, 5);
                model.setValueAt(chan.getHighLimit(), cDesc.tRow, 6);
                model.setValueAt(chan.getHighAlarm(), cDesc.tRow, 7);
                model.setValueAt(chan.getName(), cDesc.tRow, 8);
            } else {
                model.setValueAt(chan.getValue(), cDesc.tRow, 2);
            }
        }
        sDesc.channels.add(cDesc);
        sDesc.lowLimits.add(chan.getLowLimit());
        sDesc.highLimits.add(chan.getHighLimit());
        sDesc.formats.add(chan.getFormat());
    }

    private static String fmt(String format, double value) {
        return String.format(format, value);
    }

    class TextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, "  " + (String)value, false, false, row, column);
            TrendingTable tTable = (TrendingTable)table;
            if (column == 0 && tTable.isNewSection(row)) {
                c.setFont(changeFont);
            }
            return c;
        }
    }

    class AlarmCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        AlarmCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = (String)value;
            text = text == null || text.length() == 0 ? "" : "  \u2713";
            return super.getTableCellRendererComponent(table, text, false, false, row, column);
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c;
            if (value == null) {
                c = super.getTableCellRendererComponent(table, "", false, false, row, column);
                c.setBackground(Color.WHITE);
            } else {
                TrendingTable tTable = (TrendingTable)table;
                String text = SubscaleTable.fmt(tTable.getFormat(row), (Double)value);
                c = super.getTableCellRendererComponent(table, text, false, false, row, column);
                c.setBackground(tTable.getChannelColor(row));
                ((JLabel)c).setHorizontalAlignment(4);
            }
            return c;
        }
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return super.getTableCellRendererComponent(table, "", false, false, row, column);
            }
            TrendingTable tTable = (TrendingTable)table;
            String text = SubscaleTable.fmt(tTable.getFormat(row), (Double)value);
            Component c = super.getTableCellRendererComponent(table, text, false, hasFocus, row, column);
            if (column == 4 && tTable.hasLowLimitChanged(row) || column == 6 && tTable.hasHighLimitChanged(row)) {
                c.setFont(changeFont);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            return c;
        }
    }

    class DisableSystem
    implements Runnable {
        SubsysDesc sDesc;

        DisableSystem(SubsysDesc sDesc) {
            this.sDesc = sDesc;
        }

        @Override
        public void run() {
            this.sDesc.enabled = false;
            for (int row = 0; row < this.sDesc.table.model().getRowCount(); ++row) {
                this.sDesc.table.setValueAt(this.sDesc.table.getValueAt(row, 1), row, 1);
                this.sDesc.table.setValueAt(this.sDesc.table.getValueAt(row, 2), row, 2);
            }
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        SubsysDesc sDesc;
        MonitorFullState s;

        UpdateTrendingTableModel(SubsysDesc sDesc, MonitorFullState s) {
            this.sDesc = sDesc;
            this.s = s;
        }

        @Override
        public void run() {
            TrendingTableModel model = this.sDesc.table.model();
            while (model.getRowCount() > 0) {
                model.removeRow(0);
            }
            this.sDesc.enabled = true;
            this.sDesc.alarmMap.clear();
            this.sDesc.channels.clear();
            this.sDesc.goodChans.clear();
            this.sDesc.onlineChans.clear();
            this.sDesc.lowLimits.clear();
            this.sDesc.highLimits.clear();
            this.sDesc.formats.clear();
            Map alarms = this.s.getAlarms();
            for (String name : alarms.keySet()) {
                JLabel label = new JLabel((String)alarms.get(name));
                label.setBorder(LineBorder.createBlackLineBorder());
                label.setBackground(colPopup);
                label.setFont(myFont);
                this.sDesc.alarmMap.put(name, label);
            }
            for (MonitorChan chan : this.s.getChannels()) {
                SubscaleTable.this.addTrendingRow(this.sDesc, chan);
            }
            for (int c = 0; c < this.sDesc.table.getColumnCount(); ++c) {
                int r;
                TableColumnModel colModel = this.sDesc.table.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = this.sDesc.table.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(this.sDesc.table, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = this.sDesc.table.getCellRenderer(0, c);
                Class<?> colClass = this.sDesc.table.getColumnClass(c);
                if (colClass.equals(String.class) || colClass.equals(AlarmMarker.class)) {
                    for (r = 0; r < this.sDesc.table.model().getRowCount(); ++r) {
                        Object value = this.sDesc.table.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(this.sDesc.table, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                    }
                } else {
                    for (r = 0; r < this.sDesc.table.model().getRowCount(); ++r) {
                        comp = rndr.getTableCellRendererComponent(this.sDesc.table, -999.99, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                    }
                }
                col.setPreferredWidth(width + 4);
                col.setMinWidth(width + 4);
                SubscaleTable.this.updateState(this.sDesc, this.s.getMonitorState());
                Container anc = SubscaleTable.this.getTopLevelAncestor();
                if (!(anc instanceof Window)) continue;
                Dimension td = this.sDesc.table.pane.getPreferredSize();
                Dimension wd = anc.getSize();
                wd.width = Math.max(wd.width, td.width);
                wd.height = Math.max(wd.height, td.height);
                anc.setSize(wd);
            }
            SubscaleTable.this.removeAll();
            if (SubscaleTable.this.tabs.getTabCount() == 1) {
                SubscaleTable.this.add(SubscaleTable.this.tabs.getComponentAt(0));
            } else {
                SubscaleTable.this.add(SubscaleTable.this.tabs);
            }
        }
    }

    class UpdateState
    implements Runnable {
        SubsysDesc sDesc;
        MonitorState s;

        UpdateState(SubsysDesc sDesc, MonitorState s) {
            this.sDesc = sDesc;
            this.s = s;
        }

        @Override
        public void run() {
            SubscaleTable.this.updateState(this.sDesc, this.s);
        }
    }

    class UpdateLimitValue
    implements Runnable {
        SubsysDesc sDesc;
        String cName;
        String limName;
        String value;

        UpdateLimitValue(SubsysDesc sDesc, String cName, String limName, String value) {
            this.sDesc = sDesc;
            this.cName = cName;
            this.limName = limName;
            this.value = value;
        }

        @Override
        public void run() {
            ChanDesc cDesc = this.sDesc.chanMap.get(this.cName);
            if (cDesc == null) {
                return;
            }
            double limit = Double.valueOf(this.value);
            if (this.limName.equals("alarmHigh")) {
                this.sDesc.highLimits.set(cDesc.sRow, limit);
                this.sDesc.table.setValueAt(limit, cDesc.tRow, 6);
            } else {
                this.sDesc.lowLimits.set(cDesc.sRow, limit);
                this.sDesc.table.setValueAt(limit, cDesc.tRow, 4);
            }
        }
    }

    class UpdateTableValue
    implements Runnable {
        SubsysDesc sDesc;
        String cName;
        double value;

        UpdateTableValue(SubsysDesc sDesc, String cName, double value) {
            this.sDesc = sDesc;
            this.cName = cName;
            this.value = value;
        }

        @Override
        public void run() {
            ChanDesc cDesc = this.sDesc.chanMap.get(this.cName);
            if (cDesc == null) {
                return;
            }
            this.sDesc.table.setValueAt(this.value, cDesc.tRow, cDesc.tCol);
        }
    }

    static class AlarmMarker {
        AlarmMarker() {
        }
    }

    static class TrendingValue {
        TrendingValue() {
        }
    }

    static class ChanDesc {
        int sRow;
        int tRow;
        int tCol;

        ChanDesc() {
        }
    }

    static class SubsysDesc {
        String name;
        boolean enabled;
        TrendingTable table;
        Map<String, JLabel> alarmMap = new HashMap<String, JLabel>();
        Map<String, ChanDesc> chanMap = new HashMap<String, ChanDesc>();
        List<ChanDesc> channels = new ArrayList<ChanDesc>();
        BitSet goodChans = new BitSet();
        BitSet onlineChans = new BitSet();
        List<Double> lowLimits = new ArrayList<Double>();
        List<Double> highLimits = new ArrayList<Double>();
        List<String> formats = new ArrayList<String>();

        SubsysDesc() {
        }
    }

    class TrendingTableModel
    extends DefaultTableModel
    implements TableModelListener {
        TrendingTable table;
        private static final long serialVersionUID = 1L;

        public TrendingTableModel(TrendingTable table) {
            super(colNames, 0);
            this.addTableModelListener(this);
            this.table = table;
        }

        public Class getColumnClass(int column) {
            return colTypes[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
        }
    }

    class TrendingTable
    extends JTable {
        SubsysDesc sDesc;
        boolean indent;
        List<Integer> tsRowMap = new ArrayList<Integer>();
        JScrollPane pane;
        private static final long serialVersionUID = 1L;

        TrendingTable() {
        }

        void initialize(SubsysDesc sDesc, String name) {
            this.sDesc = sDesc;
            TrendingTableModel model = new TrendingTableModel(this);
            this.setModel(model);
            this.setName(name);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    SubscaleTable.this.tableMouseClicked(evt);
                }
            });
            this.pane = new JScrollPane();
            this.pane.setViewportView(this);
            this.pane.setName(name);
            SubscaleTable.this.tabs.add(this.pane);
            JTableHeader hdr = this.getTableHeader();
            hdr.setReorderingAllowed(false);
            hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
            this.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
            this.setDefaultRenderer(Double.class, new LimitsCellRenderer());
            this.setDefaultRenderer(String.class, new TextCellRenderer());
            this.setDefaultRenderer(AlarmMarker.class, new AlarmCellRenderer());
            this.setAutoResizeMode(3);
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setFont(myFont);
            this.setRowHeight(this.getRowHeight() + 2);
        }

        public TrendingTableModel model() {
            return (TrendingTableModel)super.getModel();
        }

        String getFormat(int tRow) {
            int sRow = this.tsRowMap.get(tRow);
            return sRow < 0 ? "" : this.sDesc.formats.get(sRow);
        }

        Color getChannelColor(int tRow) {
            int sRow = this.tsRowMap.get(tRow);
            return sRow < 0 ? Color.WHITE : (!this.sDesc.enabled ? Color.LIGHT_GRAY : (!this.sDesc.onlineChans.get(sRow) ? colOffln : (this.sDesc.goodChans.get(sRow) ? colGood : colError)));
        }

        boolean hasLowLimitChanged(int tRow) {
            return false;
        }

        boolean hasHighLimitChanged(int tRow) {
            return false;
        }

        boolean isNewSection(int tRow) {
            return this.tsRowMap.get(tRow) < 0;
        }
    }
}

