/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Constructor;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;

public class RefrigAssembly
extends MonitorGui.Panel {
    MonitorAssembly mon;
    RefrigControlPanel panel;
    private static final long serialVersionUID = 1L;

    public RefrigAssembly(String name, CommandSender gui) throws Exception {
        this.setLayout(new BorderLayout());
        this.mon = new MonitorAssembly(gui);
        this.add((Component)this.mon, "Center");
        Class<?> pClass = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + name + "ControlPanel");
        Constructor<?> cons = pClass.getConstructor(CommandSender.class);
        this.panel = (RefrigControlPanel)cons.newInstance(gui);
        this.add(this.panel, "South");
    }

    public void setSubsystem(String name) {
        this.panel.setSubsystem(name);
        this.mon.setSubsystems(new String[]{name});
    }

    public void disableSystem(String name, int id) {
        this.panel.disableSystem();
        this.mon.disableSystem(name);
    }

    public void updatePanel(String name, int id, Object d) {
        if (d instanceof RefrigFullState) {
            RefrigFullState r = (RefrigFullState)d;
            this.mon.updateTableModel(name, r.getMonitorFullState());
            this.panel.updateControlPanel(r.getRefrigState());
        }
    }

    public void handleStatusData(String name, int id, long time, String key, Object d) {
        if (key.equals("RefrigState")) {
            this.panel.updateControlPanel((RefrigState)((KeyValueData)d).getValue());
        } else {
            this.mon.handleData(name, key, d);
        }
    }
}

