/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;

public class LongLinesControlPanel
extends RefrigControlPanel {
    private static final Font f = new Font("Tahoma", 1, 12);
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private String subsys;
    double currentPeriod = 5.0;
    boolean limitsChanged = false;
    private JLabel loadPowerLabel;
    private JLabel loadPowerStatus;
    private JButton loadTripButton;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private JButton mainPowerButton;
    private JLabel mainPowerLabel;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JLabel stateLabel;
    private JLabel stateStatus;
    private static final long serialVersionUID = 1L;

    public LongLinesControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.stateLabel.setFont(f);
        this.stateStatus.setFont(f);
        this.mainPowerLabel.setFont(f);
        this.mainPowerStatus.setFont(f);
        this.mainPowerButton.setFont(f);
        this.loadTripLabel.setFont(f);
        this.loadTripStatus.setFont(f);
        this.loadTripButton.setFont(f);
        this.loadPowerLabel.setFont(f);
        this.loadPowerStatus.setFont(f);
        this.periodLabel.setFont(f);
        this.periodUnitsLabel.setFont(f);
        new UpdateRefrigStatus(new RefrigState0(0, 0, 0.0, 0.0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.mainPowerButton = new JButton();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.loadTripLabel = new JLabel();
        this.loadTripStatus = new JLabel();
        this.loadTripButton = new JButton();
        this.loadPowerLabel = new JLabel();
        this.loadPowerStatus = new JLabel();
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("....");
        this.mainPowerLabel.setText("Main Power:");
        this.mainPowerStatus.setText("....");
        this.mainPowerButton.setText("....");
        this.mainPowerButton.setEnabled(false);
        this.mainPowerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LongLinesControlPanel.this.mainPowerButtonActionPerformed(evt);
            }
        });
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LongLinesControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.loadTripLabel.setText("Load Power Trip:");
        this.loadTripStatus.setText("....");
        this.loadTripButton.setText("....");
        this.loadTripButton.setEnabled(false);
        this.loadTripButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LongLinesControlPanel.this.loadTripButtonActionPerformed(evt);
            }
        });
        this.loadPowerLabel.setText("Load Power:");
        this.loadPowerStatus.setText("....");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel).addComponent(this.mainPowerLabel))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.loadTripLabel))).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.periodLabel).addComponent(this.loadPowerLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.loadPowerStatus, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainPowerStatus, -1, -1, Short.MAX_VALUE).addComponent(this.loadTripStatus, -1, 68, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainPowerButton, -1, 99, Short.MAX_VALUE).addComponent(this.loadTripButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.periodTextField, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodUnitsLabel)).addComponent(this.stateStatus, GroupLayout.Alignment.LEADING)).addContainerGap(30, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateStatus).addComponent(this.stateLabel)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerLabel).addComponent(this.mainPowerStatus).addComponent(this.mainPowerButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadTripButton).addComponent(this.loadTripStatus).addComponent(this.loadTripLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadPowerLabel).addComponent(this.loadPowerStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel)).addContainerGap(22, Short.MAX_VALUE)));
    }

    private void mainPowerButtonActionPerformed(ActionEvent evt) {
        this.setMainPowerStatus(evt.getActionCommand().equals("ON"));
        this.mainPowerButton.setEnabled(false);
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.setTickMillis((int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.currentPeriod));
        }
    }

    private void loadTripButtonActionPerformed(ActionEvent evt) {
        this.setLoadTripStatus(evt.getActionCommand().equals("ON"));
        this.loadTripButton.setEnabled(false);
    }

    @Override
    public void setSubsystem(String name) {
        this.subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    void setMainPowerStatus(boolean on) {
        this.gui.sendCommand(this.subsys, null, "setMainPowerEnable", new Object[]{on ? 1 : 0});
    }

    void setLoadTripStatus(boolean on) {
        this.gui.sendCommand(this.subsys, null, "setLoadTripEnable", new Object[]{on ? 1 : 0});
    }

    void setTickMillis(int value) {
        this.gui.sendCommand(this.subsys, null, "setTickMillis", new Object[]{value});
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            LongLinesControlPanel.this.stateStatus.setText("STOPPED");
            LongLinesControlPanel.this.stateStatus.setForeground(RED);
            LongLinesControlPanel.this.mainPowerButton.setEnabled(false);
            LongLinesControlPanel.this.loadTripButton.setEnabled(false);
            LongLinesControlPanel.this.periodTextField.setEnabled(false);
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        RefrigState0 rs;

        UpdateRefrigStatus(RefrigState rs) {
            this.rs = (RefrigState0)rs;
        }

        @Override
        public void run() {
            int st = this.rs.getSystemState();
            LongLinesControlPanel.this.stateStatus.setText("RUNNING");
            LongLinesControlPanel.this.stateStatus.setForeground(GREEN);
            boolean on = (st & 1) != 0;
            boolean tr = (st & 2) != 0;
            LongLinesControlPanel.this.mainPowerStatus.setText(on ? "ON" : (tr ? "TRIPPED" : "OFF"));
            LongLinesControlPanel.this.mainPowerStatus.setForeground(on ? GREEN : (tr ? RED : Color.black));
            LongLinesControlPanel.this.mainPowerButton.setEnabled(true);
            LongLinesControlPanel.this.mainPowerButton.setText("Turn " + (on ? "OFF" : "ON"));
            LongLinesControlPanel.this.mainPowerButton.setActionCommand(on ? "OFF" : "ON");
            LongLinesControlPanel.this.loadPowerStatus.setText((on &= (st & 4) != 0) ? "ON" : "OFF");
            LongLinesControlPanel.this.loadPowerStatus.setForeground(on ? GREEN : Color.black);
            on = (st & 8) != 0;
            LongLinesControlPanel.this.loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            LongLinesControlPanel.this.loadTripStatus.setForeground(on ? GREEN : Color.black);
            LongLinesControlPanel.this.loadTripButton.setEnabled(true);
            LongLinesControlPanel.this.loadTripButton.setText(on ? "Disable" : "Enable");
            LongLinesControlPanel.this.loadTripButton.setActionCommand(on ? "OFF" : "ON");
            LongLinesControlPanel.this.periodTextField.setEnabled(true);
            LongLinesControlPanel.this.currentPeriod = (double)this.rs.getTickMillis() / 1000.0;
            LongLinesControlPanel.this.periodTextField.setText(String.valueOf(LongLinesControlPanel.this.currentPeriod));
        }
    }
}

