/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldX;

public class HXTestControlPanel
extends RefrigControlPanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final TextFieldX periodTFX;
    private final TextFieldX powerTFX;
    private final TextFieldX tempTFX;
    private String subsys;
    private boolean enabled;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton loadPowerAutoRB;
    private ButtonGroup loadPowerBG;
    private JLabel loadPowerLabel;
    private JRadioButton loadPowerManualRB;
    private JRadioButton loadPowerOffRB;
    private JLabel loadPowerStatus;
    private ButtonGroup loadTripBG;
    private JRadioButton loadTripDisableRB;
    private JRadioButton loadTripEnableRB;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private ButtonGroup mainPowerBG;
    private JRadioButton mainPowerFullRB;
    private JRadioButton mainPowerHeaterRB;
    private JLabel mainPowerLabel;
    private JRadioButton mainPowerOffRB;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JTextField powerTextField;
    private JLabel powerUnitsLabel;
    private JLabel stateLabel;
    private JLabel stateStatus;
    private JTextField tempTextField;
    private JLabel tempUnitsLabel;

    public HXTestControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.periodTFX = new TextFieldX(this.periodTextField, 2);
        this.powerTFX = new TextFieldX(this.powerTextField, 2);
        this.tempTFX = new TextFieldX(this.tempTextField, 2);
        new UpdateRefrigStatus(new RefrigState0(0, 0, 0.0, 0.0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.mainPowerBG = new ButtonGroup();
        this.loadTripBG = new ButtonGroup();
        this.loadPowerBG = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.loadPowerLabel = new JLabel();
        this.powerUnitsLabel = new JLabel();
        this.mainPowerOffRB = new JRadioButton();
        this.mainPowerFullRB = new JRadioButton();
        this.loadTripLabel = new JLabel();
        this.loadTripDisableRB = new JRadioButton();
        this.loadTripEnableRB = new JRadioButton();
        this.loadPowerManualRB = new JRadioButton();
        this.loadPowerOffRB = new JRadioButton();
        this.loadPowerAutoRB = new JRadioButton();
        this.tempTextField = new JTextField();
        this.tempUnitsLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.loadPowerStatus = new JLabel();
        this.loadTripStatus = new JLabel();
        this.stateLabel = new JLabel();
        this.mainPowerHeaterRB = new JRadioButton();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.powerTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setForeground(Color.blue);
        this.jPanel2.setFocusable(false);
        this.loadPowerLabel.setFont(new Font("Dialog", 1, 12));
        this.loadPowerLabel.setText("Heater Power:");
        this.powerUnitsLabel.setFont(new Font("Dialog", 1, 12));
        this.powerUnitsLabel.setText("watts");
        this.mainPowerBG.add(this.mainPowerOffRB);
        this.mainPowerOffRB.setFont(new Font("Dialog", 1, 12));
        this.mainPowerOffRB.setText("Off");
        this.mainPowerOffRB.setFocusable(false);
        this.mainPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.mainPowerOffRBActionPerformed(evt);
            }
        });
        this.mainPowerBG.add(this.mainPowerFullRB);
        this.mainPowerFullRB.setFont(new Font("Dialog", 1, 12));
        this.mainPowerFullRB.setText("Full");
        this.mainPowerFullRB.setFocusable(false);
        this.mainPowerFullRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.mainPowerFullRBActionPerformed(evt);
            }
        });
        this.loadTripLabel.setFont(new Font("Dialog", 1, 12));
        this.loadTripLabel.setText("Heat Load Trip:");
        this.loadTripBG.add(this.loadTripDisableRB);
        this.loadTripDisableRB.setFont(new Font("Dialog", 1, 12));
        this.loadTripDisableRB.setText("Disable");
        this.loadTripDisableRB.setFocusable(false);
        this.loadTripDisableRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.loadTripDisableRBActionPerformed(evt);
            }
        });
        this.loadTripBG.add(this.loadTripEnableRB);
        this.loadTripEnableRB.setFont(new Font("Dialog", 1, 12));
        this.loadTripEnableRB.setText("Enable");
        this.loadTripEnableRB.setFocusable(false);
        this.loadTripEnableRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.loadTripEnableRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.loadPowerManualRB);
        this.loadPowerManualRB.setFont(new Font("Dialog", 1, 12));
        this.loadPowerManualRB.setText("Manual");
        this.loadPowerManualRB.setFocusable(false);
        this.loadPowerManualRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.loadPowerManualRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.loadPowerOffRB);
        this.loadPowerOffRB.setFont(new Font("Dialog", 1, 12));
        this.loadPowerOffRB.setText("Off");
        this.loadPowerOffRB.setFocusable(false);
        this.loadPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.loadPowerOffRBActionPerformed(evt);
            }
        });
        this.loadPowerBG.add(this.loadPowerAutoRB);
        this.loadPowerAutoRB.setFont(new Font("Dialog", 1, 12));
        this.loadPowerAutoRB.setText("Auto");
        this.loadPowerAutoRB.setFocusable(false);
        this.loadPowerAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.loadPowerAutoRBActionPerformed(evt);
            }
        });
        this.tempTextField.setText("...");
        this.tempTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HXTestControlPanel.this.tempTextFieldFocusLost(evt);
            }
        });
        this.tempTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.tempTextFieldActionPerformed(evt);
            }
        });
        this.tempTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                HXTestControlPanel.this.tempTextFieldKeyTyped(evt);
            }
        });
        this.tempUnitsLabel.setFont(new Font("Dialog", 1, 12));
        this.tempUnitsLabel.setText("\u00b0C");
        this.mainPowerStatus.setFont(new Font("Dialog", 1, 12));
        this.mainPowerStatus.setText("...");
        this.loadPowerStatus.setFont(new Font("Dialog", 1, 12));
        this.loadPowerStatus.setText("...");
        this.loadTripStatus.setFont(new Font("Dialog", 1, 12));
        this.loadTripStatus.setText("...");
        this.stateLabel.setFont(new Font("Dialog", 1, 12));
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.mainPowerBG.add(this.mainPowerHeaterRB);
        this.mainPowerHeaterRB.setFont(new Font("Dialog", 1, 12));
        this.mainPowerHeaterRB.setText("Heater");
        this.mainPowerHeaterRB.setFocusable(false);
        this.mainPowerHeaterRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.mainPowerHeaterRBActionPerformed(evt);
            }
        });
        this.stateStatus.setFont(new Font("Dialog", 1, 12));
        this.stateStatus.setText("....");
        this.mainPowerLabel.setFont(new Font("Dialog", 1, 12));
        this.mainPowerLabel.setText("Main Power:");
        this.periodLabel.setFont(new Font("Dialog", 1, 12));
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HXTestControlPanel.this.periodTextFieldFocusLost(evt);
            }
        });
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                HXTestControlPanel.this.periodTextFieldKeyTyped(evt);
            }
        });
        this.periodUnitsLabel.setFont(new Font("Dialog", 1, 12));
        this.periodUnitsLabel.setText("sec");
        this.powerTextField.setText("...");
        this.powerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HXTestControlPanel.this.powerTextFieldFocusLost(evt);
            }
        });
        this.powerTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HXTestControlPanel.this.powerTextFieldActionPerformed(evt);
            }
        });
        this.powerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                HXTestControlPanel.this.powerTextFieldKeyTyped(evt);
            }
        });
        this.jPanel3.setBackground(Color.white);
        this.jPanel3.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.jPanel3.setForeground(Color.blue);
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setText("Heat");
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setForeground(Color.blue);
        this.jLabel2.setText("Exchanger");
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setForeground(Color.blue);
        this.jLabel3.setText("Test");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadPowerLabel, GroupLayout.Alignment.TRAILING).addComponent(this.loadTripLabel, GroupLayout.Alignment.TRAILING).addComponent(this.mainPowerLabel, GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.stateStatus, -2, 84, -2).addGap(70, 70, 70).addComponent(this.periodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodTextField, -1, -1, -2).addGap(6, 6, 6).addComponent(this.periodUnitsLabel)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.loadTripStatus, -2, 84, -2).addGap(1, 1, 1).addComponent(this.loadTripDisableRB).addGap(18, 18, 18).addComponent(this.loadTripEnableRB)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.loadPowerStatus, -2, 84, -2).addGap(1, 1, 1).addComponent(this.loadPowerOffRB).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.powerTextField, -2, 50, -2).addGap(4, 4, 4).addComponent(this.powerUnitsLabel)).addComponent(this.loadPowerManualRB)).addGap(27, 27, 27).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.tempTextField, -2, 50, -2).addGap(3, 3, 3).addComponent(this.tempUnitsLabel)).addComponent(this.loadPowerAutoRB))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.mainPowerStatus, -2, 84, -2).addGap(1, 1, 1).addComponent(this.mainPowerOffRB).addGap(18, 18, 18).addComponent(this.mainPowerFullRB).addGap(18, 18, 18).addComponent(this.mainPowerHeaterRB))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateLabel).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel).addComponent(this.stateStatus, -2, 17, -2)).addGap(2, 2, 2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerStatus).addComponent(this.mainPowerOffRB).addComponent(this.mainPowerFullRB).addComponent(this.mainPowerLabel).addComponent(this.mainPowerHeaterRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadTripLabel).addComponent(this.loadTripStatus).addComponent(this.loadTripDisableRB).addComponent(this.loadTripEnableRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadPowerLabel).addComponent(this.loadPowerStatus).addComponent(this.loadPowerOffRB).addComponent(this.loadPowerManualRB).addComponent(this.loadPowerAutoRB))).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addGap(6, 6, 6))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.powerTextField, -2, -1, -2).addComponent(this.powerUnitsLabel).addComponent(this.tempTextField, -2, -1, -2).addComponent(this.tempUnitsLabel)).addGap(8, 8, 8)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel2, -1, -1, -2).addGap(5, 5, 5)));
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.periodTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, "setTickMillis", new Object[]{(int)(1000.0 * value)});
        }
    }

    private void powerTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.powerTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, "setLoadPower", new Object[]{value});
        }
    }

    private void mainPowerOffRBActionPerformed(ActionEvent evt) {
        this.setMainPowerState(0);
    }

    private void loadTripDisableRBActionPerformed(ActionEvent evt) {
        this.setLoadTripState(0);
    }

    private void mainPowerFullRBActionPerformed(ActionEvent evt) {
        this.setMainPowerState(1);
    }

    private void loadTripEnableRBActionPerformed(ActionEvent evt) {
        this.setLoadTripState(1);
    }

    private void loadPowerManualRBActionPerformed(ActionEvent evt) {
        this.setLoadPowerState(1);
    }

    private void loadPowerOffRBActionPerformed(ActionEvent evt) {
        this.setLoadPowerState(0);
    }

    private void loadPowerAutoRBActionPerformed(ActionEvent evt) {
        this.setLoadPowerState(-1);
    }

    private void tempTextFieldActionPerformed(ActionEvent evt) {
        Double value = (Double)this.tempTFX.action();
        if (value != null) {
            this.gui.sendCommand(this.subsys, null, "setLoadTemp", new Object[]{value});
        }
    }

    private void mainPowerHeaterRBActionPerformed(ActionEvent evt) {
        this.setMainPowerState(-1);
    }

    private void periodTextFieldFocusLost(FocusEvent evt) {
        this.periodTFX.focusLost();
    }

    private void periodTextFieldKeyTyped(KeyEvent evt) {
        this.periodTFX.keyTyped(evt.getKeyChar());
    }

    private void powerTextFieldFocusLost(FocusEvent evt) {
        this.powerTFX.focusLost();
    }

    private void powerTextFieldKeyTyped(KeyEvent evt) {
        this.powerTFX.keyTyped(evt.getKeyChar());
    }

    private void tempTextFieldFocusLost(FocusEvent evt) {
        this.tempTFX.focusLost();
    }

    private void tempTextFieldKeyTyped(KeyEvent evt) {
        this.tempTFX.keyTyped(evt.getKeyChar());
    }

    @Override
    public void setSubsystem(String name) {
        this.subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void setMainPowerState(int value) {
        this.mainPowerOffRB.setEnabled(false);
        this.mainPowerFullRB.setEnabled(false);
        this.mainPowerHeaterRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setMainPowerEnable", new Object[]{value});
    }

    private void setLoadTripState(int value) {
        this.loadTripDisableRB.setEnabled(false);
        this.loadTripEnableRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setLoadTripEnable", new Object[]{value});
    }

    private void setLoadPowerState(int value) {
        this.loadPowerOffRB.setEnabled(false);
        this.loadPowerManualRB.setEnabled(false);
        this.loadPowerAutoRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setLoadPowerEnable", new Object[]{value});
    }

    private void setLoadPower(double value) {
        this.gui.sendCommand(this.subsys, null, "setLoadPower", new Object[]{value});
    }

    private void setLoadTemp(double value) {
        this.gui.sendCommand(this.subsys, null, "setLoadTemp", new Object[]{value});
    }

    private void setTickMillis(int value) {
        this.gui.sendCommand(this.subsys, null, "setTickMillis", new Object[]{value});
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            HXTestControlPanel.this.stateStatus.setText("STOPPED");
            HXTestControlPanel.this.stateStatus.setForeground(RED);
            HXTestControlPanel.this.mainPowerStatus.setEnabled(false);
            HXTestControlPanel.this.mainPowerOffRB.setEnabled(false);
            HXTestControlPanel.this.mainPowerFullRB.setEnabled(false);
            HXTestControlPanel.this.mainPowerHeaterRB.setEnabled(false);
            HXTestControlPanel.this.loadTripStatus.setEnabled(false);
            HXTestControlPanel.this.loadTripDisableRB.setEnabled(false);
            HXTestControlPanel.this.loadTripEnableRB.setEnabled(false);
            HXTestControlPanel.this.loadPowerStatus.setEnabled(false);
            HXTestControlPanel.this.loadPowerOffRB.setEnabled(false);
            HXTestControlPanel.this.loadPowerManualRB.setEnabled(false);
            HXTestControlPanel.this.loadPowerAutoRB.setEnabled(false);
            HXTestControlPanel.this.powerTextField.setEnabled(false);
            HXTestControlPanel.this.tempTextField.setEnabled(false);
            HXTestControlPanel.this.periodTextField.setEnabled(false);
            HXTestControlPanel.this.enabled = false;
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        private final RefrigState0 rs;

        UpdateRefrigStatus(RefrigState rs) {
            this.rs = (RefrigState0)rs;
        }

        @Override
        public void run() {
            boolean auto;
            int st;
            if (!HXTestControlPanel.this.enabled) {
                HXTestControlPanel.this.stateStatus.setText("RUNNING");
                HXTestControlPanel.this.stateStatus.setForeground(GREEN);
                HXTestControlPanel.this.mainPowerStatus.setEnabled(true);
                HXTestControlPanel.this.loadTripStatus.setEnabled(true);
                HXTestControlPanel.this.loadPowerStatus.setEnabled(true);
                HXTestControlPanel.this.enabled = true;
            }
            boolean on = ((st = this.rs.getSystemState()) & 1) != 0;
            boolean tr = (st & 2) != 0;
            boolean heat = (st & 0x20) != 0;
            HXTestControlPanel.this.mainPowerStatus.setText(on ? (heat ? "HEATER" : "FULL") : (tr ? "TRIPPED" : "OFF"));
            HXTestControlPanel.this.mainPowerStatus.setForeground(on ? GREEN : (tr ? RED : Color.black));
            JRadioButton selButton = on ? (heat ? HXTestControlPanel.this.mainPowerHeaterRB : HXTestControlPanel.this.mainPowerFullRB) : HXTestControlPanel.this.mainPowerOffRB;
            selButton.setSelected(true);
            HXTestControlPanel.this.mainPowerOffRB.setEnabled(selButton != HXTestControlPanel.this.mainPowerOffRB);
            HXTestControlPanel.this.mainPowerFullRB.setEnabled(selButton != HXTestControlPanel.this.mainPowerFullRB && !tr);
            HXTestControlPanel.this.mainPowerHeaterRB.setEnabled(selButton != HXTestControlPanel.this.mainPowerHeaterRB && !tr);
            on = (st & 8) != 0;
            HXTestControlPanel.this.loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            HXTestControlPanel.this.loadTripStatus.setForeground(on ? GREEN : Color.black);
            selButton = on ? HXTestControlPanel.this.loadTripEnableRB : HXTestControlPanel.this.loadTripDisableRB;
            selButton.setSelected(true);
            HXTestControlPanel.this.loadTripDisableRB.setEnabled(selButton != HXTestControlPanel.this.loadTripDisableRB);
            HXTestControlPanel.this.loadTripEnableRB.setEnabled(selButton != HXTestControlPanel.this.loadTripEnableRB);
            on = (st & 4) != 0;
            boolean bl = auto = (st & 0x10) != 0;
            JRadioButton jRadioButton = !on ? (auto ? null : HXTestControlPanel.this.loadPowerOffRB) : (selButton = auto ? HXTestControlPanel.this.loadPowerAutoRB : HXTestControlPanel.this.loadPowerManualRB);
            if (selButton != null) {
                selButton.setSelected(true);
                HXTestControlPanel.this.loadPowerOffRB.setEnabled(selButton != HXTestControlPanel.this.loadPowerOffRB);
                HXTestControlPanel.this.loadPowerManualRB.setEnabled(selButton != HXTestControlPanel.this.loadPowerManualRB);
                HXTestControlPanel.this.loadPowerAutoRB.setEnabled(selButton != HXTestControlPanel.this.loadPowerAutoRB);
            } else {
                HXTestControlPanel.this.loadPowerBG.clearSelection();
                HXTestControlPanel.this.loadPowerOffRB.setEnabled(false);
                HXTestControlPanel.this.loadPowerManualRB.setEnabled(false);
                HXTestControlPanel.this.loadPowerAutoRB.setEnabled(false);
                auto = (st & 1) != 0;
            }
            HXTestControlPanel.this.loadPowerStatus.setText(!on ? (auto ? "ON" : "OFF") : (auto ? "AUTO" : "MANUAL"));
            HXTestControlPanel.this.loadPowerStatus.setForeground(!on ? (auto ? GREEN : Color.black) : (auto ? RED : GREEN));
            HXTestControlPanel.this.periodTFX.update((double)this.rs.getTickMillis() / 1000.0, true);
            HXTestControlPanel.this.powerTFX.update(this.rs.getLoadPower(), selButton != null);
            HXTestControlPanel.this.tempTFX.update(this.rs.getLoadTemp(), selButton != null);
        }
    }
}

