/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldX;

public class ColdControlPanel
extends RefrigControlPanel {
    private static final Font FONT = new Font("Tahoma", 1, 12);
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final TextFieldX periodTFX;
    private final TextFieldX powerTFX;
    private final TextFieldX tempTFX;
    private String subsys;
    private boolean enabled;
    private final JPanel statePanel = new JPanel();
    private final JLabel stateLabel = new JLabel("DAQ State: ");
    private final JLabel stateStatus = new JLabel("STOPPED");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField();
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel mainPanel = new JPanel();
    private JLabel[] cmprPowerLabel;
    private JLabel[] cmprPowerStatus;
    private ButtonGroup[] cmprPowerBG;
    private JRadioButton[] cmprPowerOffRB;
    private JRadioButton[] cmprPowerOnRB;
    private final JLabel heaterPowerLabel = new JLabel("Heater Power: ");
    private final JLabel heaterPowerStatus = new JLabel("OFF");
    private final ButtonGroup heaterPowerBG = new ButtonGroup();
    private final JRadioButton heaterPowerOffRB = new JRadioButton("Off");
    private final JRadioButton heaterPowerOnRB = new JRadioButton("On");
    private final JLabel heaterControlLabel = new JLabel("Heater Control: ");
    private final JLabel heaterControlStatus = new JLabel("OFF");
    private final ButtonGroup heaterControlBG = new ButtonGroup();
    private final JRadioButton heaterControlOffRB = new JRadioButton("Off");
    private final JRadioButton heaterControlManualRB = new JRadioButton("Manual");
    private final JRadioButton heaterControlAutoRB = new JRadioButton("Auto");
    private final JPanel powerPanel = new JPanel();
    private final JTextField powerTextField = new JTextField();
    private final JLabel powerUnitsLabel = new JLabel("W");
    private final JPanel tempPanel = new JPanel();
    private final JTextField tempTextField = new JTextField();
    private final JLabel tempUnitsLabel = new JLabel("\u00b0C");
    private final int numCmpr = 1;
    private static final long serialVersionUID = 1L;

    public ColdControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.periodTFX = new TextFieldX(this.periodTextField, 2);
        this.powerTFX = new TextFieldX(this.powerTextField, 2);
        this.tempTFX = new TextFieldX(this.tempTextField, 2);
        new UpdateRefrigStatus(new RefrigState()).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel.setFont(FONT);
        this.stateStatus.setFont(FONT);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 100;
        this.stateStatus.setMinimumSize(d);
        this.stateStatus.setPreferredSize(d);
        this.periodLabel.setFont(FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ColdControlPanel.this.periodTFX.focusLost();
            }
        });
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)ColdControlPanel.this.periodTFX.action();
                if (value != null) {
                    ColdControlPanel.this.gui.sendCommand(ColdControlPanel.this.subsys, null, "setTickMillis", new Object[]{(int)(1000.0 * value)});
                }
            }
        });
        this.periodTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ColdControlPanel.this.periodTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.periodUnitsLabel.setFont(FONT);
        this.cmprPowerLabel = new JLabel[1];
        this.cmprPowerStatus = new JLabel[1];
        this.cmprPowerBG = new ButtonGroup[1];
        this.cmprPowerOffRB = new JRadioButton[1];
        this.cmprPowerOnRB = new JRadioButton[1];
        for (int j = 0; j < 1; ++j) {
            String text = "Compressor " + "" + "Power: ";
            this.cmprPowerLabel[j] = new JLabel(text);
            this.cmprPowerLabel[j].setFont(FONT);
            this.cmprPowerStatus[j] = new JLabel("OFF");
            this.cmprPowerStatus[j].setFont(FONT);
            this.cmprPowerOffRB[j] = new JRadioButton("Off");
            this.cmprPowerOffRB[j].setFont(FONT);
            this.cmprPowerOffRB[j].setFocusable(false);
            this.cmprPowerOffRB[j].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColdControlPanel.this.setCmprPowerState(evt);
                }
            });
            this.cmprPowerOnRB[j] = new JRadioButton("On");
            this.cmprPowerOnRB[j].setFont(FONT);
            this.cmprPowerOnRB[j].setFocusable(false);
            this.cmprPowerOnRB[j].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColdControlPanel.this.setCmprPowerState(evt);
                }
            });
            this.cmprPowerBG[j] = new ButtonGroup();
            this.cmprPowerBG[j].add(this.cmprPowerOffRB[j]);
            this.cmprPowerBG[j].add(this.cmprPowerOnRB[j]);
        }
        this.heaterPowerLabel.setFont(FONT);
        this.heaterPowerStatus.setFont(FONT);
        this.heaterPowerOffRB.setFont(FONT);
        this.heaterPowerOffRB.setFocusable(false);
        this.heaterPowerOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColdControlPanel.this.setHeaterPowerState(0);
            }
        });
        this.heaterPowerOnRB.setFont(FONT);
        this.heaterPowerOnRB.setFocusable(false);
        this.heaterPowerOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColdControlPanel.this.setHeaterPowerState(1);
            }
        });
        this.heaterPowerBG.add(this.heaterPowerOffRB);
        this.heaterPowerBG.add(this.heaterPowerOnRB);
        this.heaterControlLabel.setFont(FONT);
        this.heaterControlStatus.setFont(FONT);
        d = this.heaterControlStatus.getPreferredSize();
        d.width = 60;
        this.heaterControlStatus.setMinimumSize(d);
        this.heaterControlStatus.setPreferredSize(d);
        this.heaterControlOffRB.setFont(FONT);
        this.heaterControlOffRB.setFocusable(false);
        this.heaterControlOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColdControlPanel.this.setHeaterControlState(0);
            }
        });
        this.heaterControlManualRB.setFont(FONT);
        this.heaterControlManualRB.setFocusable(false);
        this.heaterControlManualRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColdControlPanel.this.setHeaterControlState(1);
            }
        });
        this.heaterControlAutoRB.setFont(FONT);
        this.heaterControlAutoRB.setFocusable(false);
        this.heaterControlAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColdControlPanel.this.setHeaterControlState(-1);
            }
        });
        this.heaterControlBG.add(this.heaterControlOffRB);
        this.heaterControlBG.add(this.heaterControlManualRB);
        this.heaterControlBG.add(this.heaterControlAutoRB);
        d = this.powerTextField.getPreferredSize();
        d.width = 50;
        this.powerTextField.setMinimumSize(d);
        this.powerTextField.setPreferredSize(d);
        this.powerTextField.setHorizontalAlignment(0);
        this.powerTextField.setText("...");
        this.powerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ColdControlPanel.this.powerTFX.focusLost();
            }
        });
        this.powerTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)ColdControlPanel.this.powerTFX.action();
                if (value != null) {
                    ColdControlPanel.this.gui.sendCommand(ColdControlPanel.this.subsys, null, "setHeaterPower", new Object[]{value});
                }
            }
        });
        this.powerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ColdControlPanel.this.powerTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.powerUnitsLabel.setFont(FONT);
        d = this.tempTextField.getPreferredSize();
        d.width = 60;
        this.tempTextField.setMinimumSize(d);
        this.tempTextField.setPreferredSize(d);
        this.tempTextField.setHorizontalAlignment(0);
        this.tempTextField.setText("...");
        this.tempTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ColdControlPanel.this.tempTFX.focusLost();
            }
        });
        this.tempTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)ColdControlPanel.this.tempTFX.action();
                if (value != null) {
                    ColdControlPanel.this.gui.sendCommand(ColdControlPanel.this.subsys, null, "setLoadTemp", new Object[]{value});
                }
            }
        });
        this.tempTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ColdControlPanel.this.tempTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.tempUnitsLabel.setFont(FONT);
        this.statePanel.add(this.stateLabel);
        this.statePanel.add(this.stateStatus);
        this.periodPanel.add(this.periodLabel);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 5, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 17;
        gbm.gridwidth = 2;
        this.mainPanel.add((Component)this.statePanel, gbm);
        gbm.anchor = 13;
        gbm.gridwidth = 3;
        gbm.gridx = 2;
        this.mainPanel.add((Component)this.periodPanel, gbm);
        gbm.gridwidth = 1;
        gbm.gridx = 0;
        ++gbm.gridy;
        gbm.anchor = 18;
        gbm.insets.bottom = 0;
        gbm.insets.left = 5;
        gbm.insets.right = 5;
        for (int j = 0; j < 1; ++j) {
            gbm.insets.top = 0;
            this.mainPanel.add((Component)this.cmprPowerLabel[j], gbm);
            ++gbm.gridx;
            this.mainPanel.add((Component)this.cmprPowerStatus[j], gbm);
            ++gbm.gridx;
            gbm.insets.top = -4;
            this.mainPanel.add((Component)this.cmprPowerOffRB[j], gbm);
            ++gbm.gridx;
            this.mainPanel.add((Component)this.cmprPowerOnRB[j], gbm);
            gbm.gridx = 0;
            ++gbm.gridy;
        }
        gbm.insets.top = 0;
        gbm.anchor = 12;
        this.mainPanel.add((Component)this.heaterPowerLabel, gbm);
        ++gbm.gridx;
        gbm.anchor = 18;
        this.mainPanel.add((Component)this.heaterPowerStatus, gbm);
        ++gbm.gridx;
        gbm.insets.top = -4;
        this.mainPanel.add((Component)this.heaterPowerOffRB, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.heaterPowerOnRB, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        gbm.insets.top = 0;
        gbm.anchor = 12;
        this.mainPanel.add((Component)this.heaterControlLabel, gbm);
        ++gbm.gridx;
        gbm.anchor = 18;
        this.mainPanel.add((Component)this.heaterControlStatus, gbm);
        ++gbm.gridx;
        gbm.insets.top = -4;
        this.mainPanel.add((Component)this.heaterControlOffRB, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.heaterControlManualRB, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.heaterControlAutoRB, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.powerPanel.add(this.powerTextField);
        this.powerPanel.add(this.powerUnitsLabel);
        this.tempPanel.add(this.tempTextField);
        this.tempPanel.add(this.tempUnitsLabel);
        gbm.gridx = 3;
        this.mainPanel.add((Component)this.powerPanel, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tempPanel, gbm);
        this.add(this.mainPanel);
    }

    @Override
    public void setSubsystem(String name) {
        this.subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void setCmprPowerState(ActionEvent evt) {
        for (int j = 0; j < 1; ++j) {
            int value = -1;
            if (evt.getSource().equals(this.cmprPowerOffRB[j])) {
                value = 0;
            } else if (evt.getSource().equals(this.cmprPowerOnRB[j])) {
                value = 1;
            }
            if (value < 0) continue;
            this.cmprPowerOffRB[j].setEnabled(false);
            this.cmprPowerOnRB[j].setEnabled(false);
            this.gui.sendCommand(this.subsys, null, "setCmprPowerEnable", new Object[]{j, value});
            return;
        }
    }

    private void setHeaterPowerState(int value) {
        this.heaterPowerOffRB.setEnabled(false);
        this.heaterPowerOnRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setHeaterPowerEnable", new Object[]{value});
    }

    private void setHeaterControlState(int value) {
        this.heaterControlOffRB.setEnabled(false);
        this.heaterControlManualRB.setEnabled(false);
        this.heaterControlAutoRB.setEnabled(false);
        this.gui.sendCommand(this.subsys, null, "setHeaterControl", new Object[]{value});
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            ColdControlPanel.this.stateStatus.setText("STOPPED");
            ColdControlPanel.this.stateStatus.setForeground(RED);
            for (int j = 0; j < 1; ++j) {
                ColdControlPanel.this.cmprPowerStatus[j].setEnabled(false);
                ColdControlPanel.this.cmprPowerOffRB[j].setEnabled(false);
                ColdControlPanel.this.cmprPowerOnRB[j].setEnabled(false);
            }
            ColdControlPanel.this.heaterPowerStatus.setEnabled(false);
            ColdControlPanel.this.heaterPowerOffRB.setEnabled(false);
            ColdControlPanel.this.heaterPowerOnRB.setEnabled(false);
            ColdControlPanel.this.heaterControlStatus.setEnabled(false);
            ColdControlPanel.this.heaterControlOffRB.setEnabled(false);
            ColdControlPanel.this.heaterControlManualRB.setEnabled(false);
            ColdControlPanel.this.heaterControlAutoRB.setEnabled(false);
            ColdControlPanel.this.periodTFX.disable();
            ColdControlPanel.this.powerTFX.disable();
            ColdControlPanel.this.tempTFX.disable();
            ColdControlPanel.this.enabled = false;
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        private final RefrigState rs;

        UpdateRefrigStatus(RefrigState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            int j;
            if (!ColdControlPanel.this.enabled) {
                ColdControlPanel.this.stateStatus.setText("RUNNING");
                ColdControlPanel.this.stateStatus.setForeground(GREEN);
                for (j = 0; j < 1; ++j) {
                    ColdControlPanel.this.cmprPowerStatus[j].setEnabled(true);
                }
                ColdControlPanel.this.heaterPowerStatus.setEnabled(true);
                ColdControlPanel.this.heaterControlStatus.setEnabled(true);
                ColdControlPanel.this.enabled = true;
            }
            for (j = 0; j < 1; ++j) {
                int state = this.rs.getCmprPowerState(j);
                ColdControlPanel.this.cmprPowerStatus[j].setText(state == 1 ? "ON" : (state == 2 ? "TRIPPED" : "OFF"));
                ColdControlPanel.this.cmprPowerStatus[j].setForeground(state == 1 ? GREEN : (state == 2 ? RED : Color.black));
                JRadioButton selButton = state == 1 ? ColdControlPanel.this.cmprPowerOnRB[j] : ColdControlPanel.this.cmprPowerOffRB[j];
                selButton.setSelected(true);
                ColdControlPanel.this.cmprPowerOffRB[j].setEnabled(state == 1);
                ColdControlPanel.this.cmprPowerOnRB[j].setEnabled(state == 0);
            }
            int state = this.rs.getHeaterPowerState();
            ColdControlPanel.this.heaterPowerStatus.setText(state == 1 ? "ON" : (state == 2 ? "TRIPPED" : "OFF"));
            ColdControlPanel.this.heaterPowerStatus.setForeground(state == 1 ? GREEN : (state == 2 ? RED : Color.black));
            JRadioButton selButton = state == 1 ? ColdControlPanel.this.heaterPowerOnRB : ColdControlPanel.this.heaterPowerOffRB;
            selButton.setSelected(true);
            ColdControlPanel.this.heaterPowerOffRB.setEnabled(state == 1);
            ColdControlPanel.this.heaterPowerOnRB.setEnabled(state == 0);
            state = this.rs.getHeaterControlState();
            ColdControlPanel.this.heaterControlStatus.setText(state == 1 ? "MANUAL" : (state == 2 ? "AUTO" : "OFF"));
            ColdControlPanel.this.heaterControlStatus.setForeground(state == 1 ? GREEN : (state == 2 ? RED : Color.black));
            selButton = state == 1 ? ColdControlPanel.this.heaterControlManualRB : (state == 2 ? ColdControlPanel.this.heaterControlAutoRB : ColdControlPanel.this.heaterControlOffRB);
            selButton.setSelected(true);
            ColdControlPanel.this.heaterControlOffRB.setEnabled(selButton != ColdControlPanel.this.heaterControlOffRB);
            ColdControlPanel.this.heaterControlManualRB.setEnabled(selButton != ColdControlPanel.this.heaterControlManualRB);
            ColdControlPanel.this.heaterControlAutoRB.setEnabled(selButton != ColdControlPanel.this.heaterControlAutoRB);
            ColdControlPanel.this.periodTFX.update((double)this.rs.getTickMillis() / 1000.0, true);
            ColdControlPanel.this.powerTFX.update(this.rs.getHeaterPower(), true);
            ColdControlPanel.this.tempTFX.update(this.rs.getLoadTemp(), true);
        }
    }
}

