package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import javax.swing.JTextField;

/**
 ******************************************************************************
 **
 **  Implements some text field extensions.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class TextFieldX {

    public static final int
        TYPE_TEXT   = 0,
        TYPE_INT    = 1,
        TYPE_DOUBLE = 2;

    private final JTextField textField;
    private final int type;
    private boolean editing;
    private Object currValue;

    public TextFieldX(JTextField tf, int typ) {
        textField = tf;
        type = typ;
        editing = false;
        currValue = null;
    }

    public void update(Object value, boolean enable) {
        currValue = value;
        if (enable) {
            textField.setEnabled(true);
        }
        if (!editing) {
            textField.setText(String.valueOf(currValue));
        }
    }

    public void keyTyped(char key) {
        if (!editing && (key >= ' ' || key == '\b')) {
            setEditing(true);
        }
    }

    public void focusLost() {
        if (editing) {
            setEditing(false);
            textField.setText(String.valueOf(currValue));
        }
    }

    public Object action() {
        if (editing) {
            setEditing(false);
            Object value;
            try {
                if (type == TYPE_DOUBLE) {
                    value = Double.valueOf(textField.getText());
                }
                else if (type == TYPE_INT) {
                    value = Integer.valueOf(textField.getText());
                }
                else {
                    value = textField.getText();
                }
                textField.setEnabled(false);
                return value;
            }
            catch(NumberFormatException nfe) {
                textField.setText(String.valueOf(currValue));
                return null;
            }
        }
        return null;
    }

    public void disable() {
        setEditing(false);
        textField.setEnabled(false);
    }

    private void setEditing(boolean state) {
        editing = state;
        textField.setForeground(editing ? Color.RED : Color.BLACK);
    }
    
}
