package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.BorderLayout;
import java.lang.reflect.Constructor;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

/**
 ******************************************************************************
 **
 **  Implements the refrigeration control panel / monitor panel assembly.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class RefrigAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    RefrigControlPanel panel;
    
    public RefrigAssembly(String name, CommandSender gui) throws Exception {

        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);        
        Class pClass = Class.forName(this.getClass().getPackage().getName()
                                       + "." + name + "ControlPanel");
        Constructor cons = pClass.getConstructor(CommandSender.class);
        panel = (RefrigControlPanel)cons.newInstance(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystem(String name) {
        panel.setSubsystem(name);
        mon.setSubsystems(name);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem();
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof RefrigFullState) {
            RefrigFullState r = (RefrigFullState)d;
            mon.updateTableModel(name, r.getMonitorFullState());
            panel.updateControlPanel(r.getRefrigState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(RefrigState.KEY)) {
            panel.updateControlPanel((RefrigState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
