/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class TextFieldX {
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_PERIOD = 1;
    private final JTextField textField;
    private final int type;
    private final String command;
    private final CommandSender sender;
    private boolean editing;
    private double currValue;

    public TextFieldX(JTextField tf, int typ, String cmnd, CommandSender sndr) {
        this.textField = tf;
        this.type = typ;
        this.command = cmnd;
        this.sender = sndr;
        this.editing = false;
        this.currValue = 0.0;
    }

    public void update(double value, boolean enable) {
        this.currValue = value;
        if (enable) {
            this.textField.setEnabled(true);
        }
        if (!this.editing) {
            this.textField.setText(String.valueOf(this.currValue));
        }
    }

    public void keyTyped(char key) {
        if (!(this.editing || key < ' ' && key != '\b')) {
            this.setEditing(true);
        }
    }

    public void focusLost() {
        if (this.editing) {
            this.setEditing(false);
            this.textField.setText(String.valueOf(this.currValue));
        }
    }

    public void action() {
        if (this.editing) {
            this.setEditing(false);
            try {
                double value = Double.valueOf(this.textField.getText());
                if (this.type == 1) {
                    this.sender.sendCommand(null, null, this.command, new Object[]{(int)(1000.0 * value)});
                } else {
                    this.sender.sendCommand(null, null, this.command, new Object[]{value});
                }
                this.textField.setEnabled(false);
            }
            catch (NumberFormatException numberFormatException) {
                this.textField.setText(String.valueOf(this.currValue));
            }
        }
    }

    public void disable() {
        this.setEditing(false);
        this.textField.setEnabled(false);
    }

    private void setEditing(boolean state) {
        this.editing = state;
        this.textField.setForeground(this.editing ? Color.RED : Color.BLACK);
    }
}

