/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.io.PrintWriter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.AgentPresenceListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigAssembly;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;

public class RefrigGUI
extends Subsystem
implements CommandSender,
DataStatusListener,
AgentPresenceListener {
    private final String subsys;
    private final SynchronousCommandAgent ca;
    private final RefrigAssembly assembly;
    private final MonitorAssembly mon;
    private final RefrigControlPanel panel;
    private PrintWriter out;
    private long lastHeartBeat;
    private boolean enabled;

    public RefrigGUI(String name) throws Exception {
        super("Refrig" + name + "GUI", Agent.AgentType.CONSOLE);
        this.ca = new SynchronousCommandAgent(this.fac);
        this.out = new PrintWriter(System.out, true);
        this.lastHeartBeat = 0L;
        this.enabled = false;
        this.assembly = new RefrigAssembly(name, this);
        this.mon = this.assembly.getMonitor();
        this.panel = this.assembly.getControlPanel();
        this.subsys = "ccs-refrig-" + name.toLowerCase();
    }

    public void initGui() {
        this.mon.setSubsystems(new String[]{this.subsys});
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.start();
        new Timer("CheckAlive", true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - RefrigGUI.this.lastHeartBeat > 10000L) {
                    RefrigGUI.this.disable();
                }
            }
        }, 0L, 5000L);
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public void resetGui() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new Exception("No Refrigeration control panel name supplied");
        }
        String name = args[0];
        RefrigGUI t = new RefrigGUI(name);
        JFrame frame = new JFrame("Refrigeration " + name + " System");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onDataArrival(String source, long time, String key, Object d) {
        if (!source.equals(this.subsys)) {
            return;
        }
        if (key.equals("RefrigState") && d instanceof RefrigState) {
            log.debug((Object)"RefrigGui received RefrigState message", new String[0]);
            this.panel.updateControlPanel((RefrigState)d);
        } else {
            this.mon.handleData(source, key, d);
        }
    }

    public void onStatus(BusMessage s) {
        if (!s.getOrigin().equals(this.subsys)) {
            return;
        }
        this.lastHeartBeat = s.getTimeStamp();
        this.enable();
        this.mon.handleStatus(s);
    }

    public void connecting(Agent agent) {
        if (agent.getName().equals(this.subsys)) {
            this.enable();
        }
    }

    public void disconnecting(Agent agent) {
        if (agent.getName().equals(this.subsys)) {
            this.disable();
        }
    }

    public String sendCommand(String dest, String target, String cmnd, Object ... args) {
        this.sendCmnd(dest, target, cmnd, args);
        return "";
    }

    private void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        Object reply = this.sendCmnd(null, null, "getFullState", new Object[0]);
        if (reply instanceof RefrigFullState) {
            log.debug((Object)"RefrigGui received RefrigFullState reply", new String[0]);
            RefrigFullState r = (RefrigFullState)reply;
            this.mon.updateTableModel(this.subsys, r.getMonitorFullState());
            this.panel.updateControlPanel(r.getRefrigState());
        } else {
            this.enabled = false;
        }
    }

    private void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.panel.disableSystem();
        this.mon.disableSystem(this.subsys);
    }

    private Object sendCmnd(String dest, String target, String cmnd, Object ... args) {
        String dst = String.valueOf(dest == null ? this.subsys : dest) + (target == null ? "" : "/" + target);
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, dst, cmnd, args);
        try {
            return this.ca.invoke((Command)cmd, 5000L);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

