package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.BorderLayout;
import java.lang.reflect.Constructor;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;

/**
 ******************************************************************************
 **
 **  Implements the refrigeration control panel / monitor panel assembly.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class RefrigAssembly extends javax.swing.JPanel {

    MonitorAssembly mon;
    RefrigControlPanel panel;
    private static final long serialVersionUID = 1L;
    
    public RefrigAssembly(String name, CommandSender gui) throws Exception {

        initComponents();
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);        
        Class pClass = Class.forName(this.getClass().getPackage().getName()
                                       + "." + name + "ControlPanel");
        Constructor cons = pClass.getConstructor(CommandSender.class);
        panel = (RefrigControlPanel)cons.newInstance(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public MonitorAssembly getMonitor() {
        return mon;
    }
    
    public RefrigControlPanel getControlPanel() {
        return panel;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
