package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

/**
 ******************************************************************************
 **
 **  Implements the refrigeration compressor test control panel.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class CompressorControlPanel extends RefrigControlPanel {

    private static final long serialVersionUID = 1L;
    private final static Color RED = new Color(150, 0, 0),
                               GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final TextFieldX periodTFX;
    private boolean enabled;

    public CompressorControlPanel(CommandSender gui) {
        this.gui = gui;
        initComponents();
        periodTFX = new TextFieldX(periodTextField, TextFieldX.TYPE_PERIOD,
                                   "setTickMillis", gui);
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPowerBG = new javax.swing.ButtonGroup();
        loadPowerBG = new javax.swing.ButtonGroup();
        jPanel2 = new javax.swing.JPanel();
        heaterPowerLabel = new javax.swing.JLabel();
        compPowerOffRB = new javax.swing.JRadioButton();
        compPowerOnRB = new javax.swing.JRadioButton();
        heaterPowerOnRB = new javax.swing.JRadioButton();
        heaterPowerOffRB = new javax.swing.JRadioButton();
        compPowerStatus = new javax.swing.JLabel();
        heaterPowerStatus = new javax.swing.JLabel();
        stateLabel = new javax.swing.JLabel();
        stateStatus = new javax.swing.JLabel();
        compPowerLabel = new javax.swing.JLabel();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        resetBtn = new javax.swing.JButton();

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setForeground(java.awt.Color.blue);
        jPanel2.setFocusable(false);

        heaterPowerLabel.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        heaterPowerLabel.setText("Heater Power:");

        mainPowerBG.add(compPowerOffRB);
        compPowerOffRB.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        compPowerOffRB.setText("Off");
        compPowerOffRB.setFocusable(false);
        compPowerOffRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                compPowerOffRBActionPerformed(evt);
            }
        });

        mainPowerBG.add(compPowerOnRB);
        compPowerOnRB.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        compPowerOnRB.setText("On");
        compPowerOnRB.setFocusable(false);
        compPowerOnRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                compPowerOnRBActionPerformed(evt);
            }
        });

        loadPowerBG.add(heaterPowerOnRB);
        heaterPowerOnRB.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        heaterPowerOnRB.setText("On");
        heaterPowerOnRB.setFocusable(false);
        heaterPowerOnRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                heaterPowerOnRBActionPerformed(evt);
            }
        });

        loadPowerBG.add(heaterPowerOffRB);
        heaterPowerOffRB.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        heaterPowerOffRB.setText("Off");
        heaterPowerOffRB.setFocusable(false);
        heaterPowerOffRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                heaterPowerOffRBActionPerformed(evt);
            }
        });

        compPowerStatus.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        compPowerStatus.setText("???");

        heaterPowerStatus.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        heaterPowerStatus.setText("???");

        stateLabel.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        stateLabel.setText("DAQ State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        stateStatus.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        stateStatus.setText("???");

        compPowerLabel.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        compPowerLabel.setText("Compressor Power:");

        periodLabel.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        periodLabel.setText("Update Period:");

        periodTextField.setText("???");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                periodTextFieldFocusLost(evt);
            }
        });
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });
        periodTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                periodTextFieldKeyTyped(evt);
            }
        });

        periodUnitsLabel.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        periodUnitsLabel.setText("sec");

        jPanel3.setBackground(java.awt.Color.white);
        jPanel3.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.blue));
        jPanel3.setForeground(java.awt.Color.blue);

        jLabel3.setFont(new java.awt.Font("Dialog", 1, 14)); // NOI18N
        jLabel3.setForeground(java.awt.Color.blue);
        jLabel3.setText("Test");

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 14)); // NOI18N
        jLabel1.setForeground(java.awt.Color.blue);
        jLabel1.setText("Compressor");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jLabel1)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addContainerGap())
        );

        resetBtn.setFont(new java.awt.Font("Dialog", 1, 12)); // NOI18N
        resetBtn.setText("Reset");
        resetBtn.setFocusable(false);
        resetBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(27, 27, 27)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(periodLabel)
                    .addComponent(heaterPowerLabel)
                    .addComponent(compPowerLabel)
                    .addComponent(stateLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(compPowerStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(heaterPowerStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(1, 1, 1)
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel2Layout.createSequentialGroup()
                                        .addComponent(heaterPowerOffRB)
                                        .addGap(18, 18, 18)
                                        .addComponent(heaterPowerOnRB))
                                    .addGroup(jPanel2Layout.createSequentialGroup()
                                        .addComponent(compPowerOffRB)
                                        .addGap(18, 18, 18)
                                        .addComponent(compPowerOnRB))))
                            .addComponent(stateStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(periodTextField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(3, 3, 3)
                        .addComponent(periodUnitsLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(resetBtn)
                        .addGap(29, 29, 29))))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(stateLabel)
                            .addComponent(stateStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(7, 7, 7)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(compPowerStatus)
                            .addComponent(compPowerOffRB)
                            .addComponent(compPowerOnRB)
                            .addComponent(compPowerLabel))
                        .addGap(3, 3, 3)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(heaterPowerLabel)
                            .addComponent(heaterPowerStatus)
                            .addComponent(heaterPowerOffRB)
                            .addComponent(heaterPowerOnRB))
                        .addGap(4, 4, 4)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(periodLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(periodUnitsLabel)
                            .addComponent(resetBtn)))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(24, 24, 24)
                        .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        periodTFX.action();
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void compPowerOffRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_compPowerOffRBActionPerformed
        setCompPowerState(0);
    }//GEN-LAST:event_compPowerOffRBActionPerformed

    private void compPowerOnRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_compPowerOnRBActionPerformed
        setCompPowerState(1);
    }//GEN-LAST:event_compPowerOnRBActionPerformed

    private void heaterPowerOnRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_heaterPowerOnRBActionPerformed
        setHeaterPowerState(1);
    }//GEN-LAST:event_heaterPowerOnRBActionPerformed

    private void heaterPowerOffRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_heaterPowerOffRBActionPerformed
        setHeaterPowerState(0);
    }//GEN-LAST:event_heaterPowerOffRBActionPerformed

    private void periodTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_periodTextFieldKeyTyped
        periodTFX.keyTyped(evt.getKeyChar());
    }//GEN-LAST:event_periodTextFieldKeyTyped

    private void periodTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_periodTextFieldFocusLost
        periodTFX.focusLost();
    }//GEN-LAST:event_periodTextFieldFocusLost

    private void resetBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetBtnActionPerformed
        reset();
    }//GEN-LAST:event_resetBtnActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel compPowerLabel;
    private javax.swing.JRadioButton compPowerOffRB;
    private javax.swing.JRadioButton compPowerOnRB;
    private javax.swing.JLabel compPowerStatus;
    private javax.swing.JLabel heaterPowerLabel;
    private javax.swing.JRadioButton heaterPowerOffRB;
    private javax.swing.JRadioButton heaterPowerOnRB;
    private javax.swing.JLabel heaterPowerStatus;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.ButtonGroup loadPowerBG;
    private javax.swing.ButtonGroup mainPowerBG;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JButton resetBtn;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    // End of variables declaration//GEN-END:variables

    @Override
    public void updateControlPanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void setCompPowerState(int value) {
        compPowerOffRB.setEnabled(false);
        compPowerOnRB.setEnabled(false);
        gui.sendCommand(null, null, "setCompPowerEnable", value);
    }

    private void setHeaterPowerState(int value) {
        heaterPowerOffRB.setEnabled(false);
        heaterPowerOnRB.setEnabled(false);
        gui.sendCommand(null, null, "setHeaterPowerEnable", value);
    }

    private void reset() {
        gui.sendCommand(null, null, "reset");
    }

    class UpdateRefrigStatus implements Runnable {

        private final RefrigState rs;

        UpdateRefrigStatus(RefrigState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            if (!enabled) {
                stateStatus.setText("RUNNING");
                stateStatus.setForeground(GREEN);
                compPowerStatus.setEnabled(true);
                heaterPowerStatus.setEnabled(true);
                resetBtn.setEnabled(true);
                enabled = true;
            }

            int st = rs.getSystemState();

            boolean on = (st & RefrigState.MAIN_POWER_STATE) != 0;
            boolean tr = (st & RefrigState.MAIN_TRIPPED_STATE) != 0;
            compPowerStatus.setText(on ? "ON" : tr ? "TRIPPED" : "OFF");
            compPowerStatus.setForeground(on ? GREEN : tr ? RED : Color.black);
            JRadioButton selButton = on ? compPowerOnRB : compPowerOffRB;
            selButton.setSelected(true);
            compPowerOffRB.setEnabled(selButton != compPowerOffRB);
            compPowerOnRB.setEnabled(selButton != compPowerOnRB && !tr);
            
            on = (st & RefrigState.LOAD_POWER_STATE) != 0;
            heaterPowerStatus.setText(on ? "ON" : "OFF");
            heaterPowerStatus.setForeground(on ? GREEN : Color.black);
            selButton = on ? heaterPowerOnRB : heaterPowerOffRB;
            selButton.setSelected(true);
            heaterPowerOffRB.setEnabled(selButton != heaterPowerOffRB);
            heaterPowerOnRB.setEnabled(selButton != heaterPowerOnRB);

            periodTFX.update(rs.getTickMillis() / 1000.0, true);
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(RED);
            compPowerStatus.setEnabled(false);
            compPowerOffRB.setEnabled(false);
            compPowerOnRB.setEnabled(false);
            heaterPowerStatus.setEnabled(false);
            heaterPowerOffRB.setEnabled(false);
            heaterPowerOnRB.setEnabled(false);
            periodTFX.disable();
            resetBtn.setEnabled(false);
            enabled = false;
        }
 
    }

}
