/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.MultiAssembly;
import org.lsst.ccs.subsystem.refrig.ui.MultiControlPanel;

public class MultiGUI
extends Subsystem
implements CommandSender,
DataStatusListener {
    private static final String LL_DEST = "ccs-refrig-longlines";
    private static final String SS_DEST = "ccs-refrig-subscale";
    private final MultiAssembly assembly;
    private final MonitorAssembly mon;
    private final MultiControlPanel panel;
    private final Map<String, SubsysDesc> subsysMap = new HashMap<String, SubsysDesc>();
    private PrintWriter out = new PrintWriter(System.out, true);

    public MultiGUI() {
        super("RefrigGUI", Agent.AgentType.CONSOLE);
        this.assembly = new MultiAssembly(this);
        this.mon = this.assembly.getMonitor();
        this.panel = this.assembly.getControlPanel();
        this.subsysMap.put(LL_DEST, new SubsysDesc(LL_DEST));
        this.subsysMap.put(SS_DEST, new SubsysDesc(SS_DEST));
    }

    public void initGui() {
        this.mon.setSubsystems(new String[]{SS_DEST, LL_DEST});
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (SubsysDesc desc : MultiGUI.this.subsysMap.values()) {
                    long delta = (System.currentTimeMillis() - desc.lastHeartBeat) / 1000L;
                    if (!desc.enabled || delta <= 10L) continue;
                    desc.enabled = false;
                    MultiGUI.this.panel.disableSystem(desc.name);
                }
            }
        }, new Date(), 5000L);
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public void resetGui() {
    }

    public static void main(String[] args) {
        MultiGUI t = new MultiGUI();
        JFrame frame = new JFrame("Refrigeration Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onReply(CommandReply s) {
        SubsysDesc desc = this.subsysMap.get(s.getOrigin());
        if (desc == null) {
            return;
        }
        if (s.getCorrelId().equals(desc.stateCorrelId)) {
            RefrigFullState r = (RefrigFullState)s.getReply();
            log.debug((Object)"RefrigGui received RefrigFullState reply", new String[0]);
            MonitorFullState m = r.getMonitorFullState();
            this.mon.updateTableModel(desc.name, m);
            this.panel.updateControlPanel(desc.name, r.getRefrigState());
            desc.enabled = true;
        }
    }

    public void onDataArrival(String source, long time, String key, Object d) {
        SubsysDesc desc = this.subsysMap.get(source);
        if (desc == null) {
            return;
        }
        if (key.equals("RefrigState") && d instanceof RefrigState) {
            log.debug((Object)("RefrigGui received RefrigState message from " + source), new String[0]);
            this.panel.updateControlPanel(source, (RefrigState)d);
        } else {
            this.mon.handleData(source, key, d);
        }
    }

    public void onStatus(BusMessage s) {
        SubsysDesc desc = this.subsysMap.get(s.getOrigin());
        if (desc == null) {
            return;
        }
        desc.lastHeartBeat = s.getTimeStamp();
        if (!desc.enabled) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - desc.lastStateRequest > 2000L) {
                desc.lastStateRequest = currentTime;
                log.debug((Object)"RefrigGui sending getFullState command", new String[0]);
                desc.stateCorrelId = this.sendCommand(desc.name, null, "getFullState", new Object[0]);
            }
            return;
        }
        this.mon.handleStatus(s);
    }

    public String sendCommand(String dest, String target, String cmnd, Object ... args) {
        String dst = String.valueOf(dest) + (target == null ? "" : "/" + target);
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, dst, cmnd, args);
        this.fac.sendCommand((Command)cmd);
        return cmd.getCorrelId();
    }

    class SubsysDesc {
        final String name;
        long lastHeartBeat = 0L;
        long lastStateRequest = 0L;
        boolean enabled = false;
        String stateCorrelId;

        SubsysDesc(String name) {
            this.name = name;
        }
    }
}

