/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

public class MultiControlPanel
extends JPanel {
    private static final String ll_dest = "ccs-refrig-longlines";
    private static final String ss_dest = "ccs-refrig-subscale";
    private static final Font f = new Font("Tahoma", 1, 12);
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private double currentPeriod = 5.0;
    private JLabel loadPowerLabel;
    private JLabel loadPowerStatus;
    private JButton loadTripButton;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private JButton mainPowerButton;
    private JLabel mainPowerLabel;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JLabel stateLabel;
    private JLabel stateStatus;

    public MultiControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.stateLabel.setFont(f);
        this.stateStatus.setFont(f);
        this.mainPowerLabel.setFont(f);
        this.mainPowerStatus.setFont(f);
        this.mainPowerButton.setFont(f);
        this.loadTripLabel.setFont(f);
        this.loadTripStatus.setFont(f);
        this.loadTripButton.setFont(f);
        this.loadPowerLabel.setFont(f);
        this.loadPowerStatus.setFont(f);
        this.periodLabel.setFont(f);
        this.periodUnitsLabel.setFont(f);
        new UpdateRefrigStatus(new RefrigState(0, 0, 0.0, 0.0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.mainPowerButton = new JButton();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.loadTripLabel = new JLabel();
        this.loadTripStatus = new JLabel();
        this.loadTripButton = new JButton();
        this.loadPowerLabel = new JLabel();
        this.loadPowerStatus = new JLabel();
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("....");
        this.mainPowerLabel.setText("Main Power:");
        this.mainPowerStatus.setText("....");
        this.mainPowerButton.setText("....");
        this.mainPowerButton.setEnabled(false);
        this.mainPowerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiControlPanel.this.mainPowerButtonActionPerformed(evt);
            }
        });
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.loadTripLabel.setText("Load Power Trip:");
        this.loadTripStatus.setText("....");
        this.loadTripButton.setText("....");
        this.loadTripButton.setEnabled(false);
        this.loadTripButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiControlPanel.this.loadTripButtonActionPerformed(evt);
            }
        });
        this.loadPowerLabel.setText("Load Power:");
        this.loadPowerStatus.setText("....");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel).addComponent(this.mainPowerLabel))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.loadTripLabel))).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.periodLabel).addComponent(this.loadPowerLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.loadPowerStatus, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainPowerStatus, -1, -1, Short.MAX_VALUE).addComponent(this.loadTripStatus, -1, 68, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainPowerButton, -1, 99, Short.MAX_VALUE).addComponent(this.loadTripButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.periodTextField, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodUnitsLabel)).addComponent(this.stateStatus, GroupLayout.Alignment.LEADING)).addContainerGap(30, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateStatus).addComponent(this.stateLabel)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerLabel).addComponent(this.mainPowerStatus).addComponent(this.mainPowerButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadTripButton).addComponent(this.loadTripStatus).addComponent(this.loadTripLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadPowerLabel).addComponent(this.loadPowerStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel)).addContainerGap(22, Short.MAX_VALUE)));
    }

    private void mainPowerButtonActionPerformed(ActionEvent evt) {
        this.setMainPowerStatusLL(evt.getActionCommand().equals("ON"));
        this.mainPowerButton.setEnabled(false);
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.setTickMillisLL((int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException numberFormatException) {
            this.periodTextField.setText(String.valueOf(this.currentPeriod));
        }
    }

    private void loadTripButtonActionPerformed(ActionEvent evt) {
        this.setLoadTripStatusLL(evt.getActionCommand().equals("ON"));
        this.loadTripButton.setEnabled(false);
    }

    public void updateControlPanel(String sName, RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    public void disableSystem(String sName) {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    public void enableSystem(String sName) {
        SwingUtilities.invokeLater(new EnableSystem());
    }

    private void setMainPowerStatusLL(boolean on) {
        this.gui.sendCommand(ll_dest, null, "setMainPowerEnable", new Object[]{on ? 1 : 0});
    }

    private void setLoadTripStatusLL(boolean on) {
        this.gui.sendCommand(ll_dest, null, "setLoadTripEnable", new Object[]{on ? 1 : 0});
    }

    private void setTickMillisLL(int value) {
        this.gui.sendCommand(ll_dest, null, "setTickMillis", new Object[]{value});
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            MultiControlPanel.this.stateStatus.setText("STOPPED");
            MultiControlPanel.this.stateStatus.setForeground(RED);
            MultiControlPanel.this.mainPowerButton.setEnabled(false);
            MultiControlPanel.this.loadTripButton.setEnabled(false);
            MultiControlPanel.this.periodTextField.setEnabled(false);
        }
    }

    class EnableSystem
    implements Runnable {
        EnableSystem() {
        }

        @Override
        public void run() {
            MultiControlPanel.this.stateStatus.setText("RUNNING");
            MultiControlPanel.this.stateStatus.setForeground(GREEN);
            MultiControlPanel.this.mainPowerButton.setEnabled(true);
            MultiControlPanel.this.loadTripButton.setEnabled(true);
            MultiControlPanel.this.periodTextField.setEnabled(true);
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        private final RefrigState rs;

        UpdateRefrigStatus(RefrigState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            int st = this.rs.getSystemState();
            MultiControlPanel.this.stateStatus.setText("RUNNING");
            MultiControlPanel.this.stateStatus.setForeground(GREEN);
            boolean on = (st & 1) != 0;
            boolean tr = (st & 2) != 0;
            MultiControlPanel.this.mainPowerStatus.setText(on ? "ON" : (tr ? "TRIPPED" : "OFF"));
            MultiControlPanel.this.mainPowerStatus.setForeground(on ? GREEN : (tr ? RED : Color.black));
            MultiControlPanel.this.mainPowerButton.setEnabled(true);
            MultiControlPanel.this.mainPowerButton.setText("Turn " + (on ? "OFF" : "ON"));
            MultiControlPanel.this.mainPowerButton.setActionCommand(on ? "OFF" : "ON");
            MultiControlPanel.this.loadPowerStatus.setText((on &= (st & 4) != 0) ? "ON" : "OFF");
            MultiControlPanel.this.loadPowerStatus.setForeground(on ? GREEN : Color.black);
            on = (st & 8) != 0;
            MultiControlPanel.this.loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            MultiControlPanel.this.loadTripStatus.setForeground(on ? GREEN : Color.black);
            MultiControlPanel.this.loadTripButton.setEnabled(true);
            MultiControlPanel.this.loadTripButton.setText(on ? "Disable" : "Enable");
            MultiControlPanel.this.loadTripButton.setActionCommand(on ? "OFF" : "ON");
            MultiControlPanel.this.periodTextField.setEnabled(true);
            MultiControlPanel.this.currentPeriod = (double)this.rs.getTickMillis() / 1000.0;
            MultiControlPanel.this.periodTextField.setText(String.valueOf(MultiControlPanel.this.currentPeriod));
        }
    }
}

