package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

/**
 ******************************************************************************
 **
 **  Implements some text field extensions.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class TextFieldX {

    public static final int
        TYPE_STANDARD = 0,
        TYPE_PERIOD = 1;

    final private JTextField textField;
    final private int type;
    final private String command;
    final private CommandSender sender;
    private boolean editing;
    private double currValue;

    public TextFieldX(JTextField tf, int typ, String cmnd, CommandSender sndr) {
        textField = tf;
        type = typ;
        command = cmnd;
        sender = sndr;
        editing = false;
        currValue = 0;
    }

    public void update(double value, boolean enable) {
        currValue = value;
        if (enable) {
            textField.setEnabled(true);
        }
        if (!editing) {
            textField.setText(String.valueOf(currValue));
        }
    }

    public void keyTyped(char key) {
        if (!editing && (key >= ' ' || key == '\b')) {
            setEditing(true);
        }
    }

    public void focusLost() {
        if (editing) {
            setEditing(false);
            textField.setText(String.valueOf(currValue));
        }
    }

    public void action() {
        if (editing) {
            setEditing(false);
            try {
                double value = Double.valueOf(textField.getText());
                if (type == TYPE_PERIOD) {
                    sender.sendCommand(null, null, command, (int)(1000 * value));
                }
                else {
                    sender.sendCommand(null, null, command, value);
                }
                textField.setEnabled(false);
            }
            catch(NumberFormatException nfe) {
                textField.setText(String.valueOf(currValue));
            }
        }
    }

    public void disable() {
        setEditing(false);
        textField.setEnabled(false);
    }

    private void setEditing(boolean state) {
        editing = state;
        textField.setForeground(editing ? Color.RED : Color.BLACK);
    }
    
}
