package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Font;
import java.util.BitSet;
import java.util.GregorianCalendar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

/**
 *
 * @author turri
 */
public class LongLinesControlPanel extends javax.swing.JPanel {

    final static Font f = new java.awt.Font("Tahoma", 1, 12);
    final static Color RED = new Color(150, 0, 0), GREEN = new Color(0, 150, 0);
    CommandSender sender;
    double currentPeriod = 5;
    boolean limitsChanged = false;

    public LongLinesControlPanel(CommandSender sender) {
        this.sender = sender;
        initComponents();
        stateLabel.setFont(f);
        stateStatus.setFont(f);
        timeLabel.setFont(f);
        timeValue.setFont(f);
        mainPowerLabel.setFont(f);
        mainPowerStatus.setFont(f);
        mainPowerButton.setFont(f);
        loadTripLabel.setFont(f);
        loadTripStatus.setFont(f);
        loadTripButton.setFont(f);
        loadPowerLabel.setFont(f);
        loadPowerStatus.setFont(f);
        periodLabel.setFont(f);
        periodUnitsLabel.setFont(f);
        limitsButton.setFont(f);
        RefrigState rs = new RefrigState(0, 0);
        MonitorState ms = new MonitorState(new BitSet(), new BitSet(),
                                           new BitSet(), new BitSet());
        (new UpdateRefrigStatus(rs, ms)).run();
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stateLabel = new javax.swing.JLabel();
        stateStatus = new javax.swing.JLabel();
        mainPowerLabel = new javax.swing.JLabel();
        mainPowerStatus = new javax.swing.JLabel();
        mainPowerButton = new javax.swing.JButton();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        limitsButton = new javax.swing.JButton();
        loadTripLabel = new javax.swing.JLabel();
        loadTripStatus = new javax.swing.JLabel();
        loadTripButton = new javax.swing.JButton();
        loadPowerLabel = new javax.swing.JLabel();
        loadPowerStatus = new javax.swing.JLabel();
        timeValue = new javax.swing.JLabel();
        timeLabel = new javax.swing.JLabel();

        stateLabel.setText("DAQ State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        stateStatus.setText("....");

        mainPowerLabel.setText("Main Power:");

        mainPowerStatus.setText("....");

        mainPowerButton.setText("....");
        mainPowerButton.setEnabled(false);
        mainPowerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mainPowerButtonActionPerformed(evt);
            }
        });

        periodLabel.setText("Update Period:");

        periodTextField.setText("...");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });

        periodUnitsLabel.setText("sec");

        limitsButton.setText("Save Limits");
        limitsButton.setEnabled(false);
        limitsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                limitsButtonActionPerformed(evt);
            }
        });

        loadTripLabel.setText("Load Power Trip:");

        loadTripStatus.setText("....");

        loadTripButton.setText("....");
        loadTripButton.setEnabled(false);
        loadTripButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTripButtonActionPerformed(evt);
            }
        });

        loadPowerLabel.setText("Load Power:");

        loadPowerStatus.setText("....");

        timeValue.setText("0000-00-00 00:00:00");

        timeLabel.setText("Last Update:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                            .addGap(41, 41, 41)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(stateLabel)
                                .addComponent(mainPowerLabel)))
                        .addGroup(layout.createSequentialGroup()
                            .addContainerGap()
                            .addComponent(loadTripLabel)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(periodLabel)
                            .addComponent(loadPowerLabel))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(loadPowerStatus)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(mainPowerStatus, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(loadTripStatus, javax.swing.GroupLayout.DEFAULT_SIZE, 68, Short.MAX_VALUE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(mainPowerButton, javax.swing.GroupLayout.DEFAULT_SIZE, 99, Short.MAX_VALUE)
                                    .addComponent(loadTripButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(periodTextField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(periodUnitsLabel)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(limitsButton))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(stateStatus)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 140, Short.MAX_VALUE)
                                .addComponent(timeLabel)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(timeValue)))
                        .addGap(28, 28, 28))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stateStatus)
                    .addComponent(stateLabel)
                    .addComponent(timeValue)
                    .addComponent(timeLabel))
                .addGap(11, 11, 11)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mainPowerLabel)
                    .addComponent(mainPowerStatus)
                    .addComponent(mainPowerButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadTripButton)
                    .addComponent(loadTripStatus)
                    .addComponent(loadTripLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadPowerLabel)
                    .addComponent(loadPowerStatus))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(periodLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(limitsButton)
                    .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(periodUnitsLabel))
                .addContainerGap(20, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void mainPowerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mainPowerButtonActionPerformed
        setMainPowerStatus(evt.getActionCommand().equals("ON"));
        mainPowerButton.setEnabled(false);
    }//GEN-LAST:event_mainPowerButtonActionPerformed

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        try {
            double value = Double.valueOf(periodTextField.getText());
            setTickMillis((int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(currentPeriod));
        }
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void limitsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_limitsButtonActionPerformed
        saveConfiguration();
        limitsButton.setEnabled(false);
    }//GEN-LAST:event_limitsButtonActionPerformed

    private void loadTripButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTripButtonActionPerformed
        setLoadTripStatus(evt.getActionCommand().equals("ON"));
        loadTripButton.setEnabled(false);
    }//GEN-LAST:event_loadTripButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton limitsButton;
    private javax.swing.JLabel loadPowerLabel;
    private javax.swing.JLabel loadPowerStatus;
    private javax.swing.JButton loadTripButton;
    private javax.swing.JLabel loadTripLabel;
    private javax.swing.JLabel loadTripStatus;
    private javax.swing.JButton mainPowerButton;
    private javax.swing.JLabel mainPowerLabel;
    private javax.swing.JLabel mainPowerStatus;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    private javax.swing.JLabel timeLabel;
    private javax.swing.JLabel timeValue;
    // End of variables declaration//GEN-END:variables

    public void updateControlPanel(RefrigState rs, MonitorState ms) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs, ms));
    }

    public void updateTime() {
        SwingUtilities.invokeLater(new UpdateTime());
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    public void enableSystem() {
        SwingUtilities.invokeLater(new EnableSystem());
    }

    javax.swing.JButton getLimitsButton() {
        return limitsButton;
    }
    
    void setMainPowerStatus(boolean on) {
        sender.sendCommand(null, new ModuleInvokerCommand("setMainPowerEnable",
                                                          on ? 1 : 0));
    }

    void setLoadTripStatus(boolean on) {
        sender.sendCommand(null, new ModuleInvokerCommand("setLoadTripEnable",
                                                          on ? 1 : 0));
    }

    void setTickMillis(int value) {
        sender.sendCommand(null, new ModuleInvokerCommand("setTickMillis",
                                                          value));
    }

    void saveConfiguration() {
        sender.sendCommand(null, new ModuleInvokerCommand("saveConfiguration"));
    }

    class UpdateRefrigStatus implements Runnable {

        RefrigState rs;
        MonitorState ms;

        UpdateRefrigStatus(RefrigState rs, MonitorState ms) {
            this.rs = rs;
            this.ms = ms;
        }

        @Override
        public void run() {
            if (rs != null) {
                int st = rs.getSystemState();

                stateStatus.setText("RUNNING");
                stateStatus.setForeground(GREEN);

                boolean on = (st & RefrigState.MAIN_POWER_STATE) != 0;
                boolean tr = (st & RefrigState.MAIN_TRIPPED_STATE) != 0;
                mainPowerStatus.setText(on ? "ON" : tr ? "TRIPPED" : "OFF");
                mainPowerStatus.setForeground(on ? GREEN : tr ? RED : Color.black);
                mainPowerButton.setEnabled(true);
                mainPowerButton.setText("Turn " + (on ? "OFF" : "ON"));
                mainPowerButton.setActionCommand(on ? "OFF" : "ON");
            
                on &= (st & RefrigState.LOAD_POWER_STATE) != 0;
                loadPowerStatus.setText(on ? "ON" : "OFF");
                loadPowerStatus.setForeground(on ? GREEN : Color.black);

                on = (st & RefrigState.LOAD_TRIP_ENAB_STATE) != 0;
                loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
                loadTripStatus.setForeground(on ? GREEN : Color.black);
                loadTripButton.setEnabled(true);
                loadTripButton.setText(on ? "Disable" : "Enable");
                loadTripButton.setActionCommand(on ? "OFF" : "ON");

                periodTextField.setEnabled(true);
                currentPeriod = rs.getTickMillis() / 1000.0;
                periodTextField.setText(String.valueOf(currentPeriod));
            }
            
            if (ms != null) {
                limitsChanged = !ms.getLowLimitChange().isEmpty()
                                  || !ms.getHighLimitChange().isEmpty();
                limitsButton.setEnabled(limitsChanged);
            }
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(RED);
            mainPowerButton.setEnabled(false);
            loadTripButton.setEnabled(false);
            periodTextField.setEnabled(false);
            limitsButton.setEnabled(false);
        }
 
    }

    class EnableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("RUNNING");
            stateStatus.setForeground(GREEN);
            mainPowerButton.setEnabled(true);
            loadTripButton.setEnabled(true);
            periodTextField.setEnabled(true);
            limitsButton.setEnabled(limitsChanged);
        }
 
    }

    class UpdateTime implements Runnable {

        @Override
        public void run() {
            showTime();
        }
    }

    private void showTime()
    {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        timeValue.setText(String.format("%tY-%<tm-%<td %<tH:%<tM:%<tS", cal));
    }
}
