/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;
import org.lsst.ccs.subsystem.refrig.ui.RefrigAssembly;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.RefrigTrendingTable;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Names;

public class RefrigGUISubsystem
extends Subsystem {
    private static final String refrig_dest = "ccs-refrig";
    private PrintWriter out = new PrintWriter(System.out, true);
    private RefrigAssembly assembly = new RefrigAssembly(this);
    private RefrigTrendingTable table = this.assembly.getTrendingTable();
    private RefrigControlPanel panel = this.assembly.getControlPanel();
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean enabled = false;
    String stateCorrelId;

    public void initGui() {
        Logger.configure();
        this.setName(Names.almostUniqueAgentName((String)"RefrigGUI"));
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long delta = (System.currentTimeMillis() - RefrigGUISubsystem.this.lastHeartBeat) / 1000L;
                if (RefrigGUISubsystem.this.enabled && delta > 10L) {
                    RefrigGUISubsystem.this.enabled = false;
                    RefrigGUISubsystem.this.panel.disableSystem();
                }
            }
        }, new Date(), 5000L);
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public void resetGui() {
    }

    public static void main(String[] args) throws ClassNotFoundException {
        RefrigGUISubsystem t = new RefrigGUISubsystem();
        JFrame frame = new JFrame("Refrigeration Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            RefrigFullState r = (RefrigFullState)s.getReply();
            log.debug((Object)"RefrigGui received RefrigFullStateStatus reply", new String[0]);
            this.table.updateTableModel(r);
            this.panel.updateControlPanel(r.getRefrigState());
            this.panel.updateTime();
            this.enabled = true;
        }
    }

    public void onStatus(BusMessage s) {
        if (!s.getOrigin().equals(refrig_dest)) {
            return;
        }
        this.lastHeartBeat = s.getTimeStamp();
        if (!this.enabled) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
                this.sendCommand(cmd);
                this.stateCorrelId = cmd.getCorrelId();
            }
            return;
        }
        if (s instanceof TrendingStatus) {
            log.debug((Object)"RefrigGui received TrendingStatus message", new String[0]);
            this.table.updateTableValue((TrendingStatus)s);
            this.panel.updateTime();
        } else if (s instanceof MetadataStatus) {
            log.debug((Object)"RefrigGui received MetadataStatus message", new String[0]);
            this.table.updateTableValue((MetadataStatus)s);
        } else if (s instanceof RefrigStateStatus) {
            log.debug((Object)"RefrigGui received RefrigStateStatus message", new String[0]);
            this.table.updateTableValue(((RefrigStateStatus)s).getRefrigState());
            this.panel.updateControlPanel(((RefrigStateStatus)s).getRefrigState());
        }
    }

    public void submitLimit(int index, double value, boolean isLowLimit) {
        Integer arg1 = index;
        Double arg2 = value;
        String command = isLowLimit ? "setLowLimit" : "setHighLimit";
        this.sendCommand(new ModuleInvokerCommand(command, new Object[]{arg1, arg2}));
    }

    public void setMainPowerStatus(boolean on) {
        this.sendCommand(new ModuleInvokerCommand("setMainPowerEnable", new Object[]{on ? 1 : 0}));
    }

    public void setLoadTripStatus(boolean on) {
        this.sendCommand(new ModuleInvokerCommand("setLoadTripEnable", new Object[]{on ? 1 : 0}));
    }

    public void setTickMillis(int value) {
        this.sendCommand(new ModuleInvokerCommand("setTickMillis", new Object[]{value}));
    }

    public void saveConfiguration() {
        this.sendCommand(new ModuleInvokerCommand("saveConfiguration", new Object[0]));
    }

    private void sendCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(refrig_dest);
        this.updateCurrentSubsystem();
        this.fac.sendCommand((Command)cmd);
    }
}

