#! /bin/sh

#
#  Run the refrigerator test GUI program
#
#  gui.sh [jg] [gc] [<host>]
#
#    jg      If present, uses jGroups instead of Glassfish
#
#    gc      If present, writes garbage collection statistics to gui_gc.log in
#            the directory containing this script
#
#    <host>  The name of the machine running the Glassfish server; default is
#            localhost.  Must follow any "jg" or "gc".
#

name=`readlink -fn $0`
BD=`dirname $name`
BR=$BD/../share/java

ND=$1
if [ "$1" == jg ] || [ "$1" == gc ]; then ND=$2; fi
if [ "$2" == jg ] || [ "$2" == gc ]; then ND=$3; fi

if [ "$1" == jg ] || [ "$2" == jg ]; then
  MF=-Dlsst.messaging.factory=org.lsst.ccs.bus.BusMessagingFactory
else
  MF=-Dlsst.messaging.factory=org.lsst.ccs.bus.jms.JMSMessagingFactory
fi

GC=""
if [ "$1" == gc ] || [ "$2" == gc ]; then
  GC=-Xloggc:./gui_gc.log
fi

CP=$BR/glassfish-embedded-all-3.1.1.jar
JAR=`ls -r $BR/org-lsst-ccs-subsystem-refrig-gui-*.jar`
CP=$CP:${JAR//$'\n'/:}
RSP=$BD/../etc

#java $GC $MF -Djava.util.logging.config.file=$RSP/logging.properties -cp $CP org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem $ND

java $GC $MF -cp $CP org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem $ND
