package org.lsst.ccs.subsystem.refrig.ui.jas;

import java.io.PrintWriter;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.plugin.jas3.LsstSubsystemPlugin;
import org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem;

/**
 *
 * @author tonyj
 */
public class RefrigJasPlugin extends LsstSubsystemPlugin {

    RefrigGUISubsystem refrigGuiSubsystem;
    FreeHEPLookup lookup;

    @Override
    protected void postInit() {
        super.postInit();
        refrigGuiSubsystem = new RefrigGUISubsystem();
        this.getApplication().getPageManager().openPage(refrigGuiSubsystem.getGuiLayout(), "Refrigeration GUI", null);
        Studio studio = (Studio) Studio.getApplication();
        lookup = studio.getLookup();
        lookup.add(this);
    }

    @Override
    public void disconnectFromMessagingFactory() {
//        closeTracerConsole("Refrig Tracer");
        refrigGuiSubsystem.resetGui();
    }

    @Override
    public void initializeRestServices() {
        registerChannelsForSubsystem("ccs-refrig");
    }

    @Override
    public void resetRestServices() {
        removeChannelsForSubsystem("ccs-refrig");
    }

    @Override
    public void connectToMessagingFactory() {
        
        refrigGuiSubsystem.initGui();        
//        Console c = createTracerConsole("Refrig Tracer", null);
//        if ( c != null ) {
//                PrintWriter pw = new PrintWriter(c.getOutputStream(null), true);
//                refrigGuiSubsystem.setPrintWriter(pw);            
//        }

        
    }
    
    
}
