/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem;

public class RefrigControlPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    RefrigGUISubsystem refrigGui;
    double currentPeriod = 5.0;
    boolean limitsChanged = false;
    private JButton limitsButton;
    private JLabel loadPowerLabel;
    private JLabel loadPowerStatus;
    private JButton loadTripButton;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private JButton mainPowerButton;
    private JLabel mainPowerLabel;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JLabel stateLabel;
    private JLabel stateStatus;
    private JLabel timeLabel;
    private JLabel timeValue;

    public RefrigControlPanel(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        this.initComponents();
        this.stateLabel.setFont(f);
        this.stateStatus.setFont(f);
        this.timeLabel.setFont(f);
        this.timeValue.setFont(f);
        this.mainPowerLabel.setFont(f);
        this.mainPowerStatus.setFont(f);
        this.mainPowerButton.setFont(f);
        this.loadTripLabel.setFont(f);
        this.loadTripStatus.setFont(f);
        this.loadTripButton.setFont(f);
        this.loadPowerLabel.setFont(f);
        this.loadPowerStatus.setFont(f);
        this.periodLabel.setFont(f);
        this.periodUnitsLabel.setFont(f);
        this.limitsButton.setFont(f);
        new UpdateRefrigStatus(new RefrigState(0, 0, 0, 0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.mainPowerButton = new JButton();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.limitsButton = new JButton();
        this.loadTripLabel = new JLabel();
        this.loadTripStatus = new JLabel();
        this.loadTripButton = new JButton();
        this.loadPowerLabel = new JLabel();
        this.loadPowerStatus = new JLabel();
        this.timeValue = new JLabel();
        this.timeLabel = new JLabel();
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("....");
        this.mainPowerLabel.setText("Main Power:");
        this.mainPowerStatus.setText("....");
        this.mainPowerButton.setText("....");
        this.mainPowerButton.setEnabled(false);
        this.mainPowerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.mainPowerButtonActionPerformed(evt);
            }
        });
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.limitsButton.setText("Save Limits");
        this.limitsButton.setEnabled(false);
        this.limitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.limitsButtonActionPerformed(evt);
            }
        });
        this.loadTripLabel.setText("Load Power Trip:");
        this.loadTripStatus.setText("....");
        this.loadTripButton.setText("....");
        this.loadTripButton.setEnabled(false);
        this.loadTripButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.loadTripButtonActionPerformed(evt);
            }
        });
        this.loadPowerLabel.setText("Load Power:");
        this.loadPowerStatus.setText("....");
        this.timeValue.setText("0000-00-00 00:00:00");
        this.timeLabel.setText("Last Update:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel).addComponent(this.mainPowerLabel))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.loadTripLabel))).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.periodLabel).addComponent(this.loadPowerLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadPowerStatus).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainPowerStatus, -1, -1, Short.MAX_VALUE).addComponent(this.loadTripStatus, -1, 68, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainPowerButton, -1, 99, Short.MAX_VALUE).addComponent(this.loadTripButton, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.periodTextField, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodUnitsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.limitsButton)).addGroup(layout.createSequentialGroup().addComponent(this.stateStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 140, Short.MAX_VALUE).addComponent(this.timeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeValue))).addGap(28, 28, 28)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateStatus).addComponent(this.stateLabel).addComponent(this.timeValue).addComponent(this.timeLabel)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerLabel).addComponent(this.mainPowerStatus).addComponent(this.mainPowerButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadTripButton).addComponent(this.loadTripStatus).addComponent(this.loadTripLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadPowerLabel).addComponent(this.loadPowerStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.limitsButton).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel)).addContainerGap(20, Short.MAX_VALUE)));
    }

    private void mainPowerButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.setMainPowerStatus(evt.getActionCommand().equals("ON"));
        this.mainPowerButton.setEnabled(false);
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.refrigGui.setTickMillis((int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException numberFormatException) {
            this.periodTextField.setText(String.valueOf(this.currentPeriod));
        }
    }

    private void limitsButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.saveConfiguration();
        this.limitsButton.setEnabled(false);
    }

    private void loadTripButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.setLoadTripStatus(evt.getActionCommand().equals("ON"));
        this.loadTripButton.setEnabled(false);
    }

    public void updateControlPanel(RefrigState s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    public void updateTime() {
        SwingUtilities.invokeLater(new UpdateTime());
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    public void enableSystem() {
        SwingUtilities.invokeLater(new EnableSystem());
    }

    JButton getLimitsButton() {
        return this.limitsButton;
    }

    private void showTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        this.timeValue.setText(String.format("%tY-%<tm-%<td %<tH:%<tM:%<tS", cal));
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.stateStatus.setText("STOPPED");
            RefrigControlPanel.this.stateStatus.setForeground(RED);
            RefrigControlPanel.this.mainPowerButton.setEnabled(false);
            RefrigControlPanel.this.loadTripButton.setEnabled(false);
            RefrigControlPanel.this.periodTextField.setEnabled(false);
            RefrigControlPanel.this.limitsButton.setEnabled(false);
        }
    }

    class EnableSystem
    implements Runnable {
        EnableSystem() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.stateStatus.setText("RUNNING");
            RefrigControlPanel.this.stateStatus.setForeground(GREEN);
            RefrigControlPanel.this.mainPowerButton.setEnabled(true);
            RefrigControlPanel.this.loadTripButton.setEnabled(true);
            RefrigControlPanel.this.periodTextField.setEnabled(true);
            RefrigControlPanel.this.limitsButton.setEnabled(RefrigControlPanel.this.limitsChanged);
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        RefrigState s;

        UpdateRefrigStatus(RefrigState s) {
            this.s = s;
        }

        @Override
        public void run() {
            int st = this.s.getSystemState();
            RefrigControlPanel.this.stateStatus.setText("RUNNING");
            RefrigControlPanel.this.stateStatus.setForeground(GREEN);
            boolean on = (st & 0x10000) != 0;
            boolean tr = (st & 0x20000) != 0;
            RefrigControlPanel.this.mainPowerStatus.setText(on ? "ON" : (tr ? "TRIPPED" : "OFF"));
            RefrigControlPanel.this.mainPowerStatus.setForeground(on ? GREEN : (tr ? RED : Color.black));
            RefrigControlPanel.this.mainPowerButton.setEnabled(true);
            RefrigControlPanel.this.mainPowerButton.setText("Turn " + (on ? "OFF" : "ON"));
            RefrigControlPanel.this.mainPowerButton.setActionCommand(on ? "OFF" : "ON");
            RefrigControlPanel.this.loadPowerStatus.setText((on &= (st & 0x40000) != 0) ? "ON" : "OFF");
            RefrigControlPanel.this.loadPowerStatus.setForeground(on ? GREEN : Color.black);
            on = (st & 0x80000) != 0;
            RefrigControlPanel.this.loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            RefrigControlPanel.this.loadTripStatus.setForeground(on ? GREEN : Color.black);
            RefrigControlPanel.this.loadTripButton.setEnabled(true);
            RefrigControlPanel.this.loadTripButton.setText(on ? "Disable" : "Enable");
            RefrigControlPanel.this.loadTripButton.setActionCommand(on ? "OFF" : "ON");
            RefrigControlPanel.this.periodTextField.setEnabled(true);
            RefrigControlPanel.this.currentPeriod = (double)this.s.getTickMillis() / 1000.0;
            RefrigControlPanel.this.periodTextField.setText(String.valueOf(RefrigControlPanel.this.currentPeriod));
            RefrigControlPanel.this.limitsChanged = (this.s.getLowLimitChange() | this.s.getHighLimitChange()) != 0;
            RefrigControlPanel.this.limitsButton.setEnabled(RefrigControlPanel.this.limitsChanged);
        }
    }

    class UpdateTime
    implements Runnable {
        UpdateTime() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.showTime();
        }
    }
}

