/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RefirgControlPanel.java
 *
 * Created on Jan 25, 2012, 8:40:10 AM
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

/**
 *
 * @author turri
 */
public class RefrigControlPanelOld extends javax.swing.JPanel {

    final static Font f = new java.awt.Font("Tahoma", 1, 12);
    final static Color myRed = new Color(150, 0, 0), myGreen = new Color(0, 150, 0);
    RefrigGUISubsystem refrigGui;
    double currentPeriod = 5;

    /** Creates new form RefirgControlPanel */
    public RefrigControlPanelOld(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        initComponents();
        mainPowerStatus.setFont(f);
        loadPowerStatus.setFont(f);
        loadTripStatus.setFont(f);
        (new UpdateRefrigStatus(new RefrigState(0, 0, 0, 0))).run();
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stateLabel = new javax.swing.JLabel();
        stateStatus = new javax.swing.JLabel();
        mainPowerLabel = new javax.swing.JLabel();
        mainPowerStatus = new javax.swing.JLabel();
        powerButton = new javax.swing.JButton();
        loadTripLabel = new javax.swing.JLabel();
        loadTripStatus = new javax.swing.JLabel();
        loadTripButton = new javax.swing.JButton();
        loadPowerLabel = new javax.swing.JLabel();
        loadPowerStatus = new javax.swing.JLabel();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        limitsButton = new javax.swing.JButton();

        stateLabel.setText("System State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        stateStatus.setText("....");

        mainPowerLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        mainPowerLabel.setText("Main Power:");

        mainPowerStatus.setText("....");

        powerButton.setText(".....");
        powerButton.setEnabled(false);
        powerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                powerButtonActionPerformed(evt);
            }
        });

        loadTripLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        loadTripLabel.setText("Load Trip:");

        loadTripStatus.setText("....");

        loadTripButton.setText(".....");
        loadTripButton.setEnabled(false);
        loadTripButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTripButtonActionPerformed(evt);
            }
        });

        loadPowerLabel.setText("Load Power:");

        loadPowerStatus.setText("....");

        periodLabel.setText("Update Period:");

        periodTextField.setText("...");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });

        periodUnitsLabel.setText("sec");

        limitsButton.setText("Save Limits");
        limitsButton.setEnabled(false);
        limitsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                limitsButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(stateLabel)
                    .addComponent(mainPowerLabel)
                    .addComponent(loadTripLabel)
                    .addComponent(loadPowerLabel)
                    .addComponent(periodLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(mainPowerStatus)
                            .addComponent(loadTripStatus))
                        .addGap(46, 46, 46)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(powerButton)
                            .addComponent(loadTripButton)))
                    .addComponent(loadPowerStatus)
                    .addComponent(stateStatus)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(periodTextField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(periodUnitsLabel)
                        .addGap(135, 135, 135)
                        .addComponent(limitsButton)))
                .addContainerGap(42, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {loadTripButton, powerButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stateStatus)
                    .addComponent(stateLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mainPowerLabel)
                    .addComponent(mainPowerStatus)
                    .addComponent(powerButton))
                .addGap(2, 2, 2)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadTripLabel)
                    .addComponent(loadTripButton)
                    .addComponent(loadTripStatus))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadPowerLabel)
                    .addComponent(loadPowerStatus))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(limitsButton)
                    .addComponent(periodLabel)
                    .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(periodUnitsLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void powerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_powerButtonActionPerformed
        refrigGui.setPowerStatus(evt.getActionCommand().equals("ON"));
        powerButton.setEnabled(false);
    }//GEN-LAST:event_powerButtonActionPerformed

    private void loadTripButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTripButtonActionPerformed
        refrigGui.setLoadTripStatus(evt.getActionCommand().equals("ON"));
        loadTripButton.setEnabled(false);
    }//GEN-LAST:event_loadTripButtonActionPerformed

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        try {
            double value = Double.valueOf(periodTextField.getText());
            refrigGui.setTickMillis((int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(currentPeriod));
        }
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void limitsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_limitsButtonActionPerformed
        refrigGui.saveConfiguration();
        limitsButton.setEnabled(false);
    }//GEN-LAST:event_limitsButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton limitsButton;
    private javax.swing.JLabel loadPowerLabel;
    private javax.swing.JLabel loadPowerStatus;
    private javax.swing.JButton loadTripButton;
    private javax.swing.JLabel loadTripLabel;
    private javax.swing.JLabel loadTripStatus;
    private javax.swing.JLabel mainPowerLabel;
    private javax.swing.JLabel mainPowerStatus;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JButton powerButton;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    // End of variables declaration//GEN-END:variables

    public void updateControlPanel(RefrigState s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    javax.swing.JButton getLimitsButton() {
        return limitsButton;
    }
    
    class UpdateRefrigStatus implements Runnable {

        RefrigState s;

        UpdateRefrigStatus(RefrigState s) {
            this.s = s;
        }

        @Override
        public void run() {
            int state = s.getSystemState();

            stateStatus.setText("RUNNING");
            stateStatus.setForeground(myGreen);

            boolean on = (state & (1 << s.MAIN_POWER_STATE_BIT)) != 0;
            mainPowerStatus.setText(on ? "ON" : "OFF");
            mainPowerStatus.setForeground(on ? myGreen : Color.black);
            powerButton.setEnabled(true);
            powerButton.setText("Turn " + (on ? "OFF" : "ON"));
            powerButton.setActionCommand(on ? "OFF" : "ON");

            on = (state & (1 << s.LOAD_TRIP_STATE_BIT)) != 0;
            loadTripStatus.setText(on ? "ON" : "OFF");
            loadTripStatus.setForeground(on ? myGreen : Color.black);
            loadTripButton.setEnabled(true);
            loadTripButton.setText("Turn " + (on ? "OFF" : "ON"));
            loadTripButton.setActionCommand(on ? "OFF" : "ON");

            on = (state & (1 << s.LOAD_POWER_STATE_BIT)) != 0;
            loadPowerStatus.setText(on ? "ON" : "OFF");
            loadPowerStatus.setForeground(on ? myGreen : Color.black);

            periodTextField.setEnabled(true);
            currentPeriod = s.getTickMillis() / 1000.0;
            periodTextField.setText(String.valueOf(currentPeriod));

            int change = s.getLowLimitChange() | s.getHighLimitChange();
            limitsButton.setEnabled(change != 0);

            repaint();
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(myRed);
            powerButton.setEnabled(false);
            loadTripButton.setEnabled(false);
            periodTextField.setEnabled(false);
            limitsButton.setEnabled(false);
        }
 
    }

}
