/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystem.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem;

public class RefrigTrendingTable
extends JPanel {
    static final String[] colNames = new String[]{"Description", "Value", "Units", "Low Limit", "High Limit", "Name"};
    static final Class[] colTypes = new Class[]{String.class, TrendingValue.class, String.class, Double.class, Double.class, String.class};
    static final boolean[] colCanEdit = new boolean[]{false, false, false, true, true, false};
    static final Color myRed = new Color(255, 160, 160);
    static final Color myGreen = new Color(160, 255, 160);
    static final Font myFont = new Font("Helvetica", 0, 12);
    static final Font changeFont = new Font("Helvetica", 1, 12);
    static final int DESCRIPTION_IND = 0;
    static final int VALUE_IND = 1;
    static final int UNITS_IND = 2;
    static final int LOW_LIMIT_IND = 3;
    static final int HIGH_LIMIT_IND = 4;
    static final int NAME_IND = 5;
    RefrigGUISubsystem refrigGui;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public RefrigTrendingTable(RefrigGUISubsystem refrigGui) {
        this.initComponents();
        JTableHeader hdr = this.jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        this.jTable1.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
        this.jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());
        this.jTable1.setDefaultRenderer(String.class, new TextCellRenderer());
        this.jTable1.setAutoResizeMode(3);
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setFont(myFont);
        this.jTable1.setRowHeight(this.jTable1.getRowHeight() + 2);
        this.refrigGui = refrigGui;
    }

    RefrigGUISubsystem getRefrigGui() {
        return this.refrigGui;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new TrendingTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    public void updateTableModel(RefrigFullState status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(status));
    }

    public void updateTableValue(RefrigState status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableState(status));
    }

    public void updateTableValue(TrendingStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTable(status));
    }

    public void updateTableValue(MetadataStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableLimits(status));
    }

    private static String fmt(double val) {
        return String.format("%.2f  ", val);
    }

    class TextCellRenderer
    extends DefaultTableCellRenderer {
        TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, "  " + (String)value, isSelected, hasFocus, row, column);
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, RefrigTrendingTable.fmt(((Float)value).floatValue()), isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (column == 1) {
                c.setBackground(model.isValueWithinLimits(row) ? myGreen : myRed);
            } else {
                c.setBackground(Color.white);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            return c;
        }
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, RefrigTrendingTable.fmt((Double)value), isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (column == 3 && model.hasLowLimitChanged(row) || column == 4 && model.hasHighLimitChanged(row)) {
                c.setFont(changeFont);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            return c;
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        RefrigFullState s;

        UpdateTrendingTableModel(RefrigFullState s) {
            this.s = s;
        }

        @Override
        public void run() {
            ArrayList channelsArray = this.s.getChannelArray();
            TrendingTableModel model = (TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel();
            int nRows = model.getRowCount();
            if (nRows != 0 && channelsArray.size() != nRows) {
                model = new TrendingTableModel();
                RefrigTrendingTable.this.jTable1.setModel(model);
                nRows = 0;
            }
            model.updateState(this.s.getRefrigState());
            if (nRows != 0) {
                for (int r = 0; r < nRows; ++r) {
                    model.updateTrendingRow(r, (RefrigChannel)channelsArray.get(r));
                }
                return;
            }
            for (RefrigChannel chan : channelsArray) {
                model.addTrendingRow(chan);
            }
            for (int c = 0; c < RefrigTrendingTable.this.jTable1.getColumnCount(); ++c) {
                TableColumnModel colModel = RefrigTrendingTable.this.jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = RefrigTrendingTable.this.jTable1.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(RefrigTrendingTable.this.jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = RefrigTrendingTable.this.jTable1.getCellRenderer(0, c);
                Class<?> colClass = RefrigTrendingTable.this.jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    comp = colClass.equals(Double.class) ? rndr.getTableCellRendererComponent(RefrigTrendingTable.this.jTable1, -999.99, false, false, 0, c) : rndr.getTableCellRendererComponent(RefrigTrendingTable.this.jTable1, Float.valueOf(-999.99f), false, false, 0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                } else {
                    for (int r = 0; r < RefrigTrendingTable.this.jTable1.getRowCount(); ++r) {
                        Object value = RefrigTrendingTable.this.jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(RefrigTrendingTable.this.jTable1, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                    }
                }
                col.setPreferredWidth(width + 4);
            }
        }
    }

    class UpdateTrendingTableLimits
    implements Runnable {
        MetadataStatus s;

        UpdateTrendingTableLimits(MetadataStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel()).updateLimit(this.s);
        }
    }

    class UpdateTrendingTableState
    implements Runnable {
        RefrigState s;

        UpdateTrendingTableState(RefrigState s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel()).updateState(this.s);
        }
    }

    class UpdateTrendingTable
    implements Runnable {
        TrendingStatus s;

        UpdateTrendingTable(TrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel()).updateValues(this.s);
        }
    }

    class TrendingValue {
        TrendingValue() {
        }
    }

    class TrendingTableModel
    extends DefaultTableModel
    implements TableModelListener {
        ArrayList<Double> lowLimits;
        ArrayList<Double> highLimits;
        int systemState;
        int lowLimitChange;
        int highLimitChange;

        public TrendingTableModel() {
            super(colNames, 0);
            this.lowLimits = new ArrayList();
            this.highLimits = new ArrayList();
            this.addTableModelListener(this);
        }

        public Class getColumnClass(int columnIndex) {
            return colTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return colCanEdit[columnIndex];
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            double oldValue;
            int column = e.getColumn();
            if (column != 3 && column != 4) {
                return;
            }
            int row = e.getFirstRow();
            boolean isLow = column == 3;
            double newValue = (Double)this.getValueAt(row, column);
            double d = oldValue = isLow ? this.getLowLimit(row) : this.getHighLimit(row);
            if (newValue != oldValue) {
                RefrigTrendingTable.this.refrigGui.submitLimit(row, newValue, isLow);
            }
        }

        void addTrendingRow(RefrigChannel chan) {
            this.lowLimits.add(chan.getLowLimit());
            this.highLimits.add(chan.getHighLimit());
            this.addRow(new Object[]{chan.getDescription(), Float.valueOf(chan.getValue()), chan.getUnits(), chan.getLowLimit(), chan.getHighLimit(), chan.getName()});
        }

        void updateTrendingRow(int row, RefrigChannel chan) {
            this.setValueAt(chan.getDescription(), row, 0);
            this.setValueAt(Float.valueOf(chan.getValue()), row, 1);
            this.setLowLimit(row, chan.getLowLimit());
            this.setHighLimit(row, chan.getHighLimit());
            this.setValueAt(chan.getUnits(), row, 2);
            this.setValueAt(chan.getName(), row, 5);
        }

        void updateValues(TrendingStatus s) {
            List vnl = (List)s.getValue();
            this.systemState = (Integer)((ValueNotification)vnl.get(vnl.size() - 1)).getData();
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.setValueAt(((ValueNotification)vnl.get(row)).getData(), row, 1);
            }
        }

        void updateState(RefrigState s) {
            int row;
            this.systemState = s.getSystemState();
            int nRows = this.getRowCount();
            int update = this.lowLimitChange ^ s.getLowLimitChange();
            this.lowLimitChange ^= update;
            for (row = 0; update != 0 && row < nRows; ++row, update >>= 1) {
                if ((update & 1) == 0) continue;
                this.setValueAt(this.getLowLimit(row), row, 3);
            }
            update = this.highLimitChange ^ s.getHighLimitChange();
            this.highLimitChange ^= update;
            for (row = 0; update != 0 && row < nRows; ++row, update >>= 1) {
                if ((update & 1) == 0) continue;
                this.setValueAt(this.getHighLimit(row), row, 4);
            }
        }

        void updateLimit(MetadataStatus s) {
            String name = s.getDataName();
            boolean high = s.getMetadataName().equals("alarmHigh");
            double limit = Double.valueOf(s.getMetadataValue());
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!name.equals((String)this.getValueAt(i, 5))) continue;
                if (high) {
                    this.setHighLimit(i, limit);
                    break;
                }
                this.setLowLimit(i, limit);
                break;
            }
        }

        boolean isValueWithinLimits(int row) {
            return (this.systemState & 1 << row) != 0;
        }

        void setLowLimit(int row, double value) {
            this.lowLimits.set(row, value);
            this.setValueAt(value, row, 3);
        }

        void setHighLimit(int row, double value) {
            this.highLimits.set(row, value);
            this.setValueAt(value, row, 4);
        }

        double getLowLimit(int row) {
            return this.lowLimits.get(row);
        }

        double getHighLimit(int row) {
            return this.highLimits.get(row);
        }

        boolean hasLowLimitChanged(int row) {
            return (this.lowLimitChange & 1 << row) != 0;
        }

        boolean hasHighLimitChanged(int row) {
            return (this.highLimitChange & 1 << row) != 0;
        }
    }
}

