/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem;

public class RefrigControlPanelOld
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color myRed = new Color(150, 0, 0);
    static final Color myGreen = new Color(0, 150, 0);
    RefrigGUISubsystem refrigGui;
    double currentPeriod = 5.0;
    private JButton limitsButton;
    private JLabel loadPowerLabel;
    private JLabel loadPowerStatus;
    private JButton loadTripButton;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private JLabel mainPowerLabel;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JButton powerButton;
    private JLabel stateLabel;
    private JLabel stateStatus;

    public RefrigControlPanelOld(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        this.initComponents();
        this.mainPowerStatus.setFont(f);
        this.loadPowerStatus.setFont(f);
        this.loadTripStatus.setFont(f);
        new UpdateRefrigStatus(new RefrigState(0, 0, 0, 0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.powerButton = new JButton();
        this.loadTripLabel = new JLabel();
        this.loadTripStatus = new JLabel();
        this.loadTripButton = new JButton();
        this.loadPowerLabel = new JLabel();
        this.loadPowerStatus = new JLabel();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.limitsButton = new JButton();
        this.stateLabel.setText("System State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("....");
        this.mainPowerLabel.setFont(new Font("Tahoma", 1, 12));
        this.mainPowerLabel.setText("Main Power:");
        this.mainPowerStatus.setText("....");
        this.powerButton.setText(".....");
        this.powerButton.setEnabled(false);
        this.powerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanelOld.this.powerButtonActionPerformed(evt);
            }
        });
        this.loadTripLabel.setFont(new Font("Tahoma", 1, 12));
        this.loadTripLabel.setText("Load Trip:");
        this.loadTripStatus.setText("....");
        this.loadTripButton.setText(".....");
        this.loadTripButton.setEnabled(false);
        this.loadTripButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanelOld.this.loadTripButtonActionPerformed(evt);
            }
        });
        this.loadPowerLabel.setText("Load Power:");
        this.loadPowerStatus.setText("....");
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanelOld.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.limitsButton.setText("Save Limits");
        this.limitsButton.setEnabled(false);
        this.limitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanelOld.this.limitsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel).addComponent(this.mainPowerLabel).addComponent(this.loadTripLabel).addComponent(this.loadPowerLabel).addComponent(this.periodLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPowerStatus).addComponent(this.loadTripStatus)).addGap(46, 46, 46).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.powerButton).addComponent(this.loadTripButton))).addComponent(this.loadPowerStatus).addComponent(this.stateStatus).addGroup(layout.createSequentialGroup().addComponent(this.periodTextField, -1, -1, -2).addGap(4, 4, 4).addComponent(this.periodUnitsLabel).addGap(135, 135, 135).addComponent(this.limitsButton))).addContainerGap(42, Short.MAX_VALUE)));
        layout.linkSize(0, this.loadTripButton, this.powerButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateStatus).addComponent(this.stateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerLabel).addComponent(this.mainPowerStatus).addComponent(this.powerButton)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadTripLabel).addComponent(this.loadTripButton).addComponent(this.loadTripStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadPowerLabel).addComponent(this.loadPowerStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitsButton).addComponent(this.periodLabel).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void powerButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.setPowerStatus(evt.getActionCommand().equals("ON"));
        this.powerButton.setEnabled(false);
    }

    private void loadTripButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.setLoadTripStatus(evt.getActionCommand().equals("ON"));
        this.loadTripButton.setEnabled(false);
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.refrigGui.setTickMillis((int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.currentPeriod));
        }
    }

    private void limitsButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.saveConfiguration();
        this.limitsButton.setEnabled(false);
    }

    public void updateControlPanel(RefrigState s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    JButton getLimitsButton() {
        return this.limitsButton;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RefrigControlPanelOld.this.stateStatus.setText("STOPPED");
            RefrigControlPanelOld.this.stateStatus.setForeground(myRed);
            RefrigControlPanelOld.this.powerButton.setEnabled(false);
            RefrigControlPanelOld.this.loadTripButton.setEnabled(false);
            RefrigControlPanelOld.this.periodTextField.setEnabled(false);
            RefrigControlPanelOld.this.limitsButton.setEnabled(false);
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        RefrigState s;

        UpdateRefrigStatus(RefrigState s) {
            this.s = s;
        }

        @Override
        public void run() {
            int state = this.s.getSystemState();
            RefrigControlPanelOld.this.stateStatus.setText("RUNNING");
            RefrigControlPanelOld.this.stateStatus.setForeground(myGreen);
            boolean on = (state & 1 << 16) != 0;
            RefrigControlPanelOld.this.mainPowerStatus.setText(on ? "ON" : "OFF");
            RefrigControlPanelOld.this.mainPowerStatus.setForeground(on ? myGreen : Color.black);
            RefrigControlPanelOld.this.powerButton.setEnabled(true);
            RefrigControlPanelOld.this.powerButton.setText("Turn " + (on ? "OFF" : "ON"));
            RefrigControlPanelOld.this.powerButton.setActionCommand(on ? "OFF" : "ON");
            on = (state & 1 << 18) != 0;
            RefrigControlPanelOld.this.loadTripStatus.setText(on ? "ON" : "OFF");
            RefrigControlPanelOld.this.loadTripStatus.setForeground(on ? myGreen : Color.black);
            RefrigControlPanelOld.this.loadTripButton.setEnabled(true);
            RefrigControlPanelOld.this.loadTripButton.setText("Turn " + (on ? "OFF" : "ON"));
            RefrigControlPanelOld.this.loadTripButton.setActionCommand(on ? "OFF" : "ON");
            on = (state & 1 << 17) != 0;
            RefrigControlPanelOld.this.loadPowerStatus.setText(on ? "ON" : "OFF");
            RefrigControlPanelOld.this.loadPowerStatus.setForeground(on ? myGreen : Color.black);
            RefrigControlPanelOld.this.periodTextField.setEnabled(true);
            RefrigControlPanelOld.this.currentPeriod = (double)this.s.getTickMillis() / 1000.0;
            RefrigControlPanelOld.this.periodTextField.setText(String.valueOf(RefrigControlPanelOld.this.currentPeriod));
            int change = this.s.getLowLimitChange() | this.s.getHighLimitChange();
            RefrigControlPanelOld.this.limitsButton.setEnabled(change != 0);
            RefrigControlPanelOld.this.repaint();
        }
    }
}

