/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigGUISubsystem;

public class RefrigControlPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color myRed = new Color(150, 0, 0);
    static final Color myGreen = new Color(0, 150, 0);
    RefrigGUISubsystem refrigGui;
    double currentPeriod = 5.0;
    boolean limitsChanged = false;
    private JButton limitsButton;
    private JLabel mainPowerLabel;
    private JLabel mainPowerStatus;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JButton powerButton;
    private JLabel stateLabel;
    private JLabel stateStatus;

    public RefrigControlPanel(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        this.initComponents();
        this.stateLabel.setFont(f);
        this.stateStatus.setFont(f);
        this.mainPowerLabel.setFont(f);
        this.mainPowerStatus.setFont(f);
        this.powerButton.setFont(f);
        this.periodLabel.setFont(f);
        this.periodUnitsLabel.setFont(f);
        this.limitsButton.setFont(f);
        new UpdateRefrigStatus(new RefrigState(0, 0, 0, 0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.mainPowerLabel = new JLabel();
        this.mainPowerStatus = new JLabel();
        this.powerButton = new JButton();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.limitsButton = new JButton();
        this.stateLabel.setText("DAQ State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("....");
        this.mainPowerLabel.setText("Main Power:");
        this.mainPowerStatus.setText("....");
        this.powerButton.setText(".....");
        this.powerButton.setEnabled(false);
        this.powerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.powerButtonActionPerformed(evt);
            }
        });
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.limitsButton.setText("Save Limits");
        this.limitsButton.setEnabled(false);
        this.limitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.limitsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stateLabel).addComponent(this.mainPowerLabel).addComponent(this.periodLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stateStatus).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPowerStatus).addComponent(this.periodTextField, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.powerButton).addGroup(layout.createSequentialGroup().addComponent(this.periodUnitsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 126, Short.MAX_VALUE).addComponent(this.limitsButton))))).addContainerGap(43, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateStatus).addComponent(this.stateLabel)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainPowerLabel).addComponent(this.mainPowerStatus).addComponent(this.powerButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.periodLabel, -2, 25, -2).addComponent(this.periodTextField, -2, -1, -2).addComponent(this.periodUnitsLabel).addComponent(this.limitsButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void powerButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.setPowerStatus(evt.getActionCommand().equals("ON"));
        this.powerButton.setEnabled(false);
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.refrigGui.setTickMillis((int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.currentPeriod));
        }
    }

    private void limitsButtonActionPerformed(ActionEvent evt) {
        this.refrigGui.saveConfiguration();
        this.limitsButton.setEnabled(false);
    }

    public void updateControlPanel(RefrigState s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    public void enableSystem() {
        SwingUtilities.invokeLater(new EnableSystem());
    }

    JButton getLimitsButton() {
        return this.limitsButton;
    }

    class EnableSystem
    implements Runnable {
        EnableSystem() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.stateStatus.setText("RUNNING");
            RefrigControlPanel.this.stateStatus.setForeground(myGreen);
            RefrigControlPanel.this.powerButton.setEnabled(true);
            RefrigControlPanel.this.periodTextField.setEnabled(true);
            RefrigControlPanel.this.limitsButton.setEnabled(RefrigControlPanel.this.limitsChanged);
        }
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.stateStatus.setText("STOPPED");
            RefrigControlPanel.this.stateStatus.setForeground(myRed);
            RefrigControlPanel.this.powerButton.setEnabled(false);
            RefrigControlPanel.this.periodTextField.setEnabled(false);
            RefrigControlPanel.this.limitsButton.setEnabled(false);
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        RefrigState s;

        UpdateRefrigStatus(RefrigState s) {
            this.s = s;
        }

        @Override
        public void run() {
            int state = this.s.getSystemState();
            RefrigControlPanel.this.stateStatus.setText("RUNNING");
            RefrigControlPanel.this.stateStatus.setForeground(myGreen);
            boolean on = (state & 0x10000) != 0;
            RefrigControlPanel.this.mainPowerStatus.setText(on ? "ON" : "OFF");
            RefrigControlPanel.this.mainPowerStatus.setForeground(on ? myGreen : Color.black);
            RefrigControlPanel.this.powerButton.setEnabled(true);
            RefrigControlPanel.this.powerButton.setText("Turn " + (on ? "OFF" : "ON"));
            RefrigControlPanel.this.powerButton.setActionCommand(on ? "OFF" : "ON");
            RefrigControlPanel.this.periodTextField.setEnabled(true);
            RefrigControlPanel.this.currentPeriod = (double)this.s.getTickMillis() / 1000.0;
            RefrigControlPanel.this.periodTextField.setText(String.valueOf(RefrigControlPanel.this.currentPeriod));
            RefrigControlPanel.this.limitsChanged = (this.s.getLowLimitChange() | this.s.getHighLimitChange()) != 0;
            RefrigControlPanel.this.limitsButton.setEnabled(RefrigControlPanel.this.limitsChanged);
            RefrigControlPanel.this.repaint();
        }
    }
}

