/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RefirgControlPanel.java
 *
 * Created on Jan 25, 2012, 8:40:10 AM
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

/**
 *
 * @author turri
 */
public class RefrigControlPanel extends javax.swing.JPanel {

    final static Font f = new java.awt.Font("Tahoma", 1, 12);
    final static Color myRed = new Color(150, 0, 0), myGreen = new Color(0, 150, 0);
    RefrigGUISubsystem refrigGui;
    double currentPeriod = 5;
    boolean limitsChanged = false;

    public RefrigControlPanel(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        initComponents();
        stateLabel.setFont(f);
        stateStatus.setFont(f);
        mainPowerLabel.setFont(f);
        mainPowerStatus.setFont(f);
        powerButton.setFont(f);
        periodLabel.setFont(f);
        periodUnitsLabel.setFont(f);
        limitsButton.setFont(f);
        (new UpdateRefrigStatus(new RefrigState(0, 0, 0, 0))).run();
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stateLabel = new javax.swing.JLabel();
        stateStatus = new javax.swing.JLabel();
        mainPowerLabel = new javax.swing.JLabel();
        mainPowerStatus = new javax.swing.JLabel();
        powerButton = new javax.swing.JButton();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        limitsButton = new javax.swing.JButton();

        stateLabel.setText("DAQ State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        stateStatus.setText("....");

        mainPowerLabel.setText("Main Power:");

        mainPowerStatus.setText("....");

        powerButton.setText(".....");
        powerButton.setEnabled(false);
        powerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                powerButtonActionPerformed(evt);
            }
        });

        periodLabel.setText("Update Period:");

        periodTextField.setText("...");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });

        periodUnitsLabel.setText("sec");

        limitsButton.setText("Save Limits");
        limitsButton.setEnabled(false);
        limitsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                limitsButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(stateLabel)
                    .addComponent(mainPowerLabel)
                    .addComponent(periodLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(stateStatus)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(mainPowerStatus)
                            .addComponent(periodTextField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(powerButton)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(periodUnitsLabel)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 126, Short.MAX_VALUE)
                                .addComponent(limitsButton)))))
                .addContainerGap(43, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stateStatus)
                    .addComponent(stateLabel))
                .addGap(11, 11, 11)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mainPowerLabel)
                    .addComponent(mainPowerStatus)
                    .addComponent(powerButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(periodLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(periodUnitsLabel)
                    .addComponent(limitsButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void powerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_powerButtonActionPerformed
        refrigGui.setPowerStatus(evt.getActionCommand().equals("ON"));
        powerButton.setEnabled(false);
    }//GEN-LAST:event_powerButtonActionPerformed

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        try {
            double value = Double.valueOf(periodTextField.getText());
            refrigGui.setTickMillis((int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(currentPeriod));
        }
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void limitsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_limitsButtonActionPerformed
        refrigGui.saveConfiguration();
        limitsButton.setEnabled(false);
    }//GEN-LAST:event_limitsButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton limitsButton;
    private javax.swing.JLabel mainPowerLabel;
    private javax.swing.JLabel mainPowerStatus;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JButton powerButton;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    // End of variables declaration//GEN-END:variables

    public void updateControlPanel(RefrigState s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    public void enableSystem() {
        SwingUtilities.invokeLater(new EnableSystem());
    }

    javax.swing.JButton getLimitsButton() {
        return limitsButton;
    }
    
    class UpdateRefrigStatus implements Runnable {

        RefrigState s;

        UpdateRefrigStatus(RefrigState s) {
            this.s = s;
        }

        @Override
        public void run() {
            int state = s.getSystemState();

            stateStatus.setText("RUNNING");
            stateStatus.setForeground(myGreen);

            boolean on = (state & (1 << RefrigState.MAIN_POWER_STATE_BIT)) != 0;
            mainPowerStatus.setText(on ? "ON" : "OFF");
            mainPowerStatus.setForeground(on ? myGreen : Color.black);
            powerButton.setEnabled(true);
            powerButton.setText("Turn " + (on ? "OFF" : "ON"));
            powerButton.setActionCommand(on ? "OFF" : "ON");

            periodTextField.setEnabled(true);
            currentPeriod = s.getTickMillis() / 1000.0;
            periodTextField.setText(String.valueOf(currentPeriod));

            limitsChanged
              = (s.getLowLimitChange() | s.getHighLimitChange()) != 0;
            limitsButton.setEnabled(limitsChanged);

            repaint();
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(myRed);
            powerButton.setEnabled(false);
            periodTextField.setEnabled(false);
            limitsButton.setEnabled(false);
        }
 
    }

    class EnableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("RUNNING");
            stateStatus.setForeground(myGreen);
            powerButton.setEnabled(true);
            periodTextField.setEnabled(true);
            limitsButton.setEnabled(limitsChanged);
        }
 
    }

}
