package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Protection Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum ChillerPlcAlert {

    /**
     * Chiller PLC is unresponsive or has error conditions
     */
    PLC_NOT_ALIVE("PLCNotAlive", "Chiller protection PLC not alive"),
    SMOKE_DETC("SmokeDetc", "Smoke detected"),
    NO_PERMIT("NoPermit", "Permit not present"),
    EXT_EMO("ExternalEMO", "External EMO asserted"),
    BD_SUPPLY_ERROR("BDSupplyError", "Burst disk supply pressure > 5.0"),
    BD_RETURN_ERROR("BDReturnError", "Burst disk return pressure > 5.0"),
    BD_SUPPLY_WARN("BDSupplyWarn", "Burst disk supply pressure > 4.5"),
    BD_RETURN_WARN("BDReturnWarn", "Burst disk return pressure > 4.5");
        
    private final String id, description;
    
    ChillerPlcAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id, description);
    }
    
}
