package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;

/**
 *  Contains the chiller control state, used for updating GUIs
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class ChillerControlState implements Serializable {
    
    public static final String KEY = "ChillerControlState";
    public static final int N_LIGHTS = 2;
    private int fastPeriod;           // Fast status updating period (ms)
    private ChillerState chillerState = ChillerState.OFFLINE;
    private double defaultRamp;
    private double flowSet;
    private double setPoint;
    private double tankSet;
    private String temperatureMode;
    private double lastRamp;
    private boolean chillerErrorEMO;
    private boolean chillerErrorOther;
    private boolean chillerWarning;
    private SwitchState[] lightState = {SwitchState.OFFLINE, SwitchState.OFFLINE};
    private final ChillerPlcState plcState = new ChillerPlcState();

    public void setFastPeriod(int value) {
        fastPeriod = value;
    }

    public int getFastPeriod() {
        return fastPeriod;
    }

    public void setChillerState(ChillerState value) {
        chillerState = value;
    }

    public ChillerState getChillerState() {
        return chillerState;
    }

    public void setDefaultRamp(double value) {
        defaultRamp = value;
    }

    public double getDefaultRamp() {
        return defaultRamp;
    }

    public void setFlowSet(double value) {
        flowSet = value;
    }

    public double getFlowSet() {
        return flowSet;
    }

    public void setSetPoint(double value) {
        setPoint = value;
    }

    public double getSetPoint() {
        return setPoint;
    }

    public void setTankSet(double value) {
        tankSet = value;
    }

    public double getTankSet() {
        return tankSet;
    }

    public void setTemperatureMode(String value) {
        temperatureMode = value;
    }

    public String getTemperatureMode() {
        return temperatureMode;
    }

    public void setLastRamp(double value) {
        lastRamp = value;
    }

    public double getLastRamp() {
        return lastRamp;
    }

    public void setChillerErrorEMO(boolean value) {
        chillerErrorEMO = value;
    }

    public boolean getChillerErrorEMO() {
        return chillerErrorEMO;
    }

    public void setChillerErrorOther(boolean value) {
        chillerErrorOther = value;
    }

    public boolean getChillerErrorOther() {
        return chillerErrorOther;
    }

    public void setChillerWarning(boolean value) {
        chillerWarning = value;
    }

    public boolean getChillerWarning() {
        return chillerWarning;
    }

    public void setLightState(SwitchState[] value) {
	lightState = value;
    }

    public SwitchState[] getLightState() {
	return lightState;
    }

    public ChillerPlcState getPlcState() {
        return plcState;
    }

    private static final long serialVersionUID = 6649854689132126155L;
}
