package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;

/**
 *  Contains the chiller control state, used for updating GUIs
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class ChillerControlState implements Serializable {
    
    public static final String KEY = "ChillerControlState";
    private int fastPeriod;           // Fast status updating period (ms)
    private ChillerState chillerState = ChillerState.OFFLINE;
    private double defaultRamp;
    private double flowSet;
    private double setPoint;
    private double tankSet;
    private String temperatureMode;
    
    public void setFastPeriod(int value) {
        fastPeriod = value;
    }

    public int getFastPeriod() {
        return fastPeriod;
    }

    public void setChillerState(ChillerState value) {
        chillerState = value;
    }

    public ChillerState getChillerState() {
        return chillerState;
    }

    public void setDefaultRamp(double value) {
        defaultRamp = value;
    }

    public double getDefaultRamp() {
        return defaultRamp;
    }

    public void setFlowSet(double value) {
        flowSet = value;
    }

    public double getFlowSet() {
        return flowSet;
    }

    public void setSetPoint(double value) {
        setPoint = value;
    }

    public double getSetPoint() {
        return setPoint;
    }

    public void setTankSet(double value) {
        tankSet = value;
    }

    public double getTankSet() {
        return tankSet;
    }

    public void setTemperatureMode(String value) {
        temperatureMode = value;
    }

    public String getTemperatureMode() {
        return temperatureMode;
    }

    private static final long serialVersionUID = 8745260658557707223L;
}
