package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for InTest Chiller
 *
 *  @author Al Eisner
 */
public enum ChillerAlerts {

    CHILLER_ERR     ("ChillerErr",   "Chiller-controller error or warning"),
    TEMP_TIMEOUT    ("TempTimeout",  "Setting chiller temperature timed out"),
    FLOW_TIMEOUT    ("FlowTimeout",  "Setting chiller flow timed out"),
    DEPARTED_SETPT  ("DepartedSetpt","Chiller unexpectedly left setpoint"),
    LOST_LISTENED   ("LostListened", "Required listened-to subsys disconneted"),
    MISSING_THERMAL ("MissingThermal", "Listened-for data missing too long");

    private final String id, description;
    
    ChillerAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(getId(), getDescription());
    }

}
