package org.lsst.ccs.subsystem.refrig.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *  Trim heater identifiers
 *
 *  @author saxton
 */
public class TrimHeaters {

    public static final int
        TRIM_HEATER_CRYO     = 0,
        TRIM_HEATER_COLD     = 1,
        TRIM_HEATER_COLD_MYE = 2,
        TRIM_HEATER_COLD_PYE = 3,
        TRIM_HEATER_COLD_C   = 4,
        TRIM_HEATER_COLD_MYC = 5,
        TRIM_HEATER_COLD_PYC = 6,
        NUM_TRIM_HEATERS     = 7;

    public static final Map<Integer, String> ID_MAP = new LinkedHashMap<>();
    static {
        ID_MAP.put(TRIM_HEATER_CRYO, "Cryo");
        ID_MAP.put(TRIM_HEATER_COLD, "Cold");
        ID_MAP.put(TRIM_HEATER_COLD_MYE, "ColdMye");
        ID_MAP.put(TRIM_HEATER_COLD_PYE, "ColdPye");
        ID_MAP.put(TRIM_HEATER_COLD_C, "ColdC");
        ID_MAP.put(TRIM_HEATER_COLD_MYC, "ColdMyc");
        ID_MAP.put(TRIM_HEATER_COLD_PYC, "ColdPyc");
    } 
    
    public static final Map<String, Integer> NAME_MAP= new LinkedHashMap<>();
    static {
        for (Map.Entry e : ID_MAP.entrySet()) {
            NAME_MAP.put((String)e.getValue(), (int)e.getKey());
        }
    }

    public static Integer getHeaterId(String name)
    {
        return NAME_MAP.get(name);
    }

    public static String getHeaterName(int id)
    {
        return ID_MAP.get(id);
    }

    public static List<String> getHeaterNames()
    {
        return new ArrayList<>(NAME_MAP.keySet());
    }

}
