package org.lsst.ccs.subsystem.refrig.constants;

/**
 *  Definitions for compressor software conditions.
 * 
 *  @author saxton
 */
public class CompSwConds {
    
    public static final int
        SWC_DISC_PRESS     = 0,
        SWC_DISC_TEMP      = 1,
        SWC_SUCT_TEMP      = 2,
        SWC_CMPR_POWER     = 3,
        SWC_PHASE_SEP_TEMP = 4,
        SWC_PLATE_TEMP     = 5,
        SWC_OIL_LEVEL      = 6,
        SWC_LIQUID_TEMP    = 7,
        SWC_PRESS_DIFF     = 8,
        SWC_DISC_TEMP_LOW  = 9,
        SWC_VACUUM_BAD     = 10,
        SWC_HEATER_TEMP    = 11,  // Not for controlling compressor
        SWC_ORF_ON_PRESS   = 12,  // Not for controlling compressor
        SWC_ORF_OFF_PRESS  = 13,  // Not for controlling compressor
        NUM_SW_CONDITIONS  = 14;

    public static final String[] DESCS = new String[NUM_SW_CONDITIONS];
    static {
        DESCS[SWC_CMPR_POWER]     = "Compr power";
        DESCS[SWC_DISC_PRESS]     = "Disch press";
        DESCS[SWC_DISC_TEMP]      = "Disch temp";
        DESCS[SWC_LIQUID_TEMP]    = "Liquid temp";
        DESCS[SWC_OIL_LEVEL]      = "Oil Level";
        DESCS[SWC_PHASE_SEP_TEMP] = "Phase sep temp";
        DESCS[SWC_SUCT_TEMP]      = "Suction temp";
        DESCS[SWC_PLATE_TEMP]     = "Plate temp";
        DESCS[SWC_DISC_TEMP_LOW]  = "Disch temp low";
        DESCS[SWC_VACUUM_BAD]     = "Vacuum bad";
        DESCS[SWC_PRESS_DIFF]     = "Pressure diff";
    }

}
