package org.lsst.ccs.subsystem.refrig.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 *  Definitions for cold compressor valves.
 * 
 *  @author saxton
 */
public class ColdCompValves {

    public static final int
        VALVE_HGB     = 0,
        VALVE_COOLANT = 1,
        VALVE_EEPR    = 2,
        NUM_VALVES    = 3;

    public static final Map<Integer, String> ID_MAP = new LinkedHashMap<>();
    static {
        ID_MAP.put(VALVE_HGB,     "HGB");
        ID_MAP.put(VALVE_COOLANT, "Coolant");
        ID_MAP.put(VALVE_EEPR,    "EEPR");
    }

    public static final Map<String, Integer> NAME_MAP= new LinkedHashMap<>();
    static {
        for (Map.Entry e : ID_MAP.entrySet()) {
            NAME_MAP.put((String)e.getValue(), (int)e.getKey());
        }
    }

    public static final String[] DESCS = new String[NUM_VALVES];
    static {
        DESCS[VALVE_HGB]     = "HGB valve";
        DESCS[VALVE_COOLANT] = "Coolant valve";
        DESCS[VALVE_EEPR]    = "EEPR valve";
    }

}
