package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Protection Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum PcpAlert {

    /**
     * PCP PLC is unresponsive or has error conditions
     */
    CHILLER_PLC_NOT_ALIVE("ChillerPLCNotAlive", "Chiller protection PLC not alive"),
    HEATER_PLC_NOT_ALIVE("HeaterPLCNotAlive", "Heater protection PLC not alive"),
    COLD_TEMP_HIGH("ColdTempHigh", "Cold temperature high"),
    COLD_TEMP_LOW("ColdTempLow", "Cold temperature low"),
    SMOKE_DETC("SmokeDetc", "Smoke detected");
        
    private final String id, description;
    
    PcpAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id, description);
    }
    
}
