package org.lsst.ccs.subsystem.refrig.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

/**
 *  Definitions for PCP heaters.
 * 
 *  @author saxton
 */
public class PcpHeaters {
    
    public static final int
        HEATER_MINUS_Y = 0,
        HEATER_CENTER  = 1,
        HEATER_PLUS_Y  = 2,
        NUM_HEATERS    = 3;

    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<>();
    static {
        NAME_MAP.put("MinusY", HEATER_MINUS_Y);
        NAME_MAP.put("Center", HEATER_CENTER);
        NAME_MAP.put("PlusY", HEATER_PLUS_Y);
        NAME_MAP.put("Center", HEATER_CENTER);
    }

    private static final Map<Integer, String> ID_MAP= new LinkedHashMap<>();
    static {
        for (Map.Entry e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), (String)e.getKey());
        }
    }

    /**
     *  Gets the list of heater names.
     * 
     *  @return  The list of names
     */
    public static List<String> getNames()
    {
        return new ArrayList<>(NAME_MAP.keySet());
    }

    /**
     *  Gets a heater name from its ID.
     * 
     *  @param  id  The heater id
     *  @return  The heater name
     */
    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    /**
     *  Gets a heater ID from its name.
     * 
     *  @param  name  The heater name
     *  @return  The heater ID
     *  @throws  RefrigException
     */
    public static int getId(String name) throws RefrigException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new RefrigException("Invalid heater name: " + name);
        }
        return id;
    }

}
