package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Thermal Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum ThermalAlert {

    COLD_TEMP_HIGH("ColdTempHigh", "Cold-plate temperature high"),
    COLD_COMP_OFF("ColdCompOff", "Cold compressors off"),
    COLD_TEMP_LOW("ColdTempLow", "Cold-plate temperature low"),
    CRYO_TEMP_LOW("CryoTempLow", "Cryo-plate temperature low");
        
    private final String id, description;
    
    ThermalAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(id, description);
    }
    
}
