package org.lsst.ccs.subsystem.refrig.constants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

/**
 *  Definitions of the chiller system PLC latches.
 *
 *  @author The CCS team
 */
public class ChillerLatches {

    public static final int
        LATCH_SMOKE_DETC  = 0,
        LATCH_PERMIT      = 1,
        LATCH_EXT_EMO     = 2,
        LATCH_BD_SUPPLY_P = 3,
        LATCH_BD_RETURN_P = 4,
        NUM_LATCHES       = 5;

    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<>();
    static {
        NAME_MAP.put("SmokeDetc", LATCH_SMOKE_DETC);
        NAME_MAP.put("Permit", LATCH_PERMIT);
        NAME_MAP.put("ExtEMO", LATCH_EXT_EMO);
        NAME_MAP.put("BDSupplyP", LATCH_BD_SUPPLY_P);
        NAME_MAP.put("BDReturnP", LATCH_BD_RETURN_P);
    }

    private static final Map<Integer, String> ID_MAP= new LinkedHashMap<>();
    static {
        for (Map.Entry e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), (String)e.getKey());
        }
    }

    /**
     *  Gets the list of latch names.
     * 
     *  @return  The list of names
     */
    public static List<String> getNames()
    {
        return new ArrayList<>(NAME_MAP.keySet());
    }

    /**
     *  Gets a latch name from its ID.
     * 
     *  @param  id  The latch id
     *  @return  The latch name
     */
    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    /**
     *  Gets a latch ID from its name.
     * 
     *  @param  name  The latch name
     *  @return  The latch ID
     *  @throws  RefrigException
     */
    public static int getId(String name) throws RefrigException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new RefrigException("Invalid latch name: " + name);
        }
        return id;
    }

}
