/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

public enum ChillerAlerts {
    CHILLER_ERR("ChillerErr", "Chiller-controller error or warning"),
    TEMP_TIMEOUT("TempTimeout", "Setting chiller temperature timed out"),
    FLOW_TIMEOUT("FlowTimeout", "Setting chiller flow timed out"),
    DEPARTED_SETPT("DepartedSetpt", "Chiller unexpectedly left setpoint");

    private final String id;
    private final String description;

    private ChillerAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert newAlert() {
        return new Alert(this.getId(), this.getDescription());
    }
}

