package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import org.lsst.ccs.bus.data.Alert;

/**
 *  Manages the refrig alert action payload
 * 
 *  @author saxton
 */
public class RefrigAction implements Serializable {

    public enum Action { STOP_CRYO_COMP, STOP_ALL_CRYO_COMPS, STOP_COLD_COMP, STOP_ALL_COLD_COMPS }

    public Action action;    // The action to perform
    public String compName;  // The compressor name (where applicable)


    /**
     *  Constructor.
     * 
     *  @param action  The action to perform
     *  @param compName  The compressor name
     */
    public RefrigAction(Action action, String compName)
    {
        this.action = action;
        this.compName = compName;
    }


    /**
     *  Gets the simple name of this class.
     * 
     *  @return  The name
     */
    public static String getName()
    {
        return RefrigAction.class.getSimpleName();
    }


    /**
     *  Gets the name of the client property.
     * 
     *  @return  The name
     */
    public static String getClientName()
    {
        return getName() + "Client";
    }


    /**
     *  Gets the name of the manager property.
     * 
     *  @return  The name
     */
    public static String getManagerName()
    {
        return getName() + "Manager";
    }


    /**
     *  Adds data to an alert
     * 
     *  @param  alert  The alert
     *  @param  action  The action to perform
     *  @param  compName  The affected compressor name
     */
    public static void addData(Alert alert, Action action, String compName)
    {
        alert.addAlertData(getName(), new RefrigAction(action, compName));
    }


    /**
     *  Gets data from an alert.
     * 
     *  @param  alert  The alert
     *  @return  The action, or null if the alert doesn't contain MPM data
     */
    public static RefrigAction getData(Alert alert)
    {
        Object data = alert.getAlertData(getName());
        return data instanceof RefrigAction ? (RefrigAction)data : null;
    }

    private static final long serialVersionUID = -3592204026173235108L;
}
