package org.lsst.ccs.subsystem.refrig.data;

import org.lsst.ccs.bus.annotations.SkipEncoding;
import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.refrig.constants.PcpHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.PcpHeaters;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.PLCState;
import org.lsst.ccs.subsystem.refrig.constants.PcpConditions;
import org.lsst.ccs.subsystem.refrig.constants.PcpLatches;
import org.lsst.ccs.subsystem.refrig.constants.PcpLimits;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitchState;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitches;

/**
 *  Contains the state of the PCP subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class PcpSysState implements Serializable {
    
    public static final String KEY = "PcpState";
    private int tickMillis;           // Data status update period (ms)
    private PLCState plcState = PLCState.ALIVE;  // PLC state
    private final PcpSwitchState[] switchState = new PcpSwitchState[PcpSwitches.NUM_SWITCHES];  // Switch state array
    private final LatchState[] latchState = new LatchState[PcpLatches.NUM_LATCHES];  // Latched PLC conditions array
    private final ConditionState[] conditionState = new ConditionState[PcpConditions.NUM_CONDITIONS];  // PLC conditions array
    private final int[] tempLimit = new int[PcpLimits.NUM_LIMITS];  // Cold plate temperature limits
    private final PcpHeaterState[] heaterState = new PcpHeaterState[PcpHeaters.NUM_AUX_HEATERS];  // Aux heater power state
    private final double[] heaterPower = new double[PcpHeaters.NUM_AUX_HEATERS];  // Aux heater power set point

    public PcpSysState() {
        Arrays.fill(switchState, PcpSwitchState.OFFLINE);
        Arrays.fill(latchState, LatchState.OFFLINE);
        Arrays.fill(conditionState, ConditionState.OFF);
        Arrays.fill(tempLimit, Integer.MAX_VALUE);
        Arrays.fill(heaterState, PcpHeaterState.OFFLINE);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setPlcState(PLCState value) {
        plcState = value;
    }

    public PLCState getPlcState() {
        return plcState;
    }

    public void setSwitchState(int sw, PcpSwitchState state) {
        switchState[sw] = state;
    }

    public PcpSwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return conditionState[cond];
    }

    public void setLimit(int limit, int value) {
        tempLimit[limit] = value;
    }

    public int getLimit(int limit) {
        return tempLimit[limit];
    }

    public void setHeaterState(int heater, PcpHeaterState state) {
        heaterState[heater] = state;
    }

    public PcpHeaterState getHeaterState(int heater) {
        return heaterState[heater];
    }

    public void setHeaterPower(int heater, double value) {
        heaterPower[heater] = value;
    }

    public double getHeaterPower(int heater) {
        return heaterPower[heater];
    }

    private static final long serialVersionUID = 2009439736778543360L;
}
