package org.lsst.ccs.subsystem.refrig.constants;

import java.util.HashSet;
import java.util.Set;

/**
 *  Defines the possible auxiliary heater states
 *
 *  @author Owen Saxton
 */
public enum PcpHeaterState { OFF, ON, VOLTERR, NOLOAD, CANTSET, DISABLD, OFFLINE;

    private static final Set<PcpHeaterState> onStates = new HashSet<>();
    static {
        onStates.add(PcpHeaterState.ON);
        onStates.add(PcpHeaterState.VOLTERR);
        onStates.add(PcpHeaterState.CANTSET);
        onStates.add(PcpHeaterState.NOLOAD);
    }

    public static boolean isOnState(PcpHeaterState state) {
        return onStates.contains(state);
    }

}
