package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for InTest Chiller
 *
 *  @author Al Eisner
 */
public enum ChillerAlerts {

    CHILLER_ERR     ("ChillerErr", "Chiller-controller error or warning");

    private final String id, description;
    
    ChillerAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(getId(), getDescription());
    }

}
