package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.AuxHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;

/**
 *  Contains the state of the thermal system
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class ThermalState implements Serializable {

    public static final String KEY = "ThermalState";

    public static final int
        TRIM_HEATER_CRYO     = 0,
        TRIM_HEATER_COLD     = 1,
        TRIM_HEATER_COLD_MYE = 2,
        TRIM_HEATER_COLD_PYE = 3,
        TRIM_HEATER_COLD_C   = 4,
        TRIM_HEATER_COLD_MYC = 5,
        TRIM_HEATER_COLD_PYC = 6,
        NUM_TRIM_HEATERS     = 7,
        AUX_HEATER_MINUS_Y   = 0,
        AUX_HEATER_PLUS_Y    = 1,
        AUX_HEATER_CENTER    = 2,
        NUM_AUX_HEATERS      = 3;

    private int tickMillis;         // Data status update period (ms)
    private Integer[] trimHeaters = new Integer[0];
    private final TrimHeaterOpState[] trimHeaterOpState = new TrimHeaterOpState[NUM_TRIM_HEATERS];  // Trim heater operation state
    private final TrimHeaterState[] trimHeaterState = new TrimHeaterState[NUM_TRIM_HEATERS];  // Trim heater state
    private final double[] trimHeaterPower = new double[NUM_TRIM_HEATERS];          // Trim heater power set point
    private final double[] plateTemperature = new double[NUM_TRIM_HEATERS];         // Plate temperature set point
    private Integer[] auxHeaters = new Integer[0];
    private final AuxHeaterState[] auxHeaterState = new AuxHeaterState[NUM_AUX_HEATERS];  // Aux heater state
    private final double[] auxHeaterPower = new double[NUM_AUX_HEATERS];                  // Aux heater power set point

    public ThermalState() {
        Arrays.fill(trimHeaterOpState, TrimHeaterOpState.OFF);
        Arrays.fill(trimHeaterState, TrimHeaterState.OFFLINE);
        Arrays.fill(auxHeaterState, AuxHeaterState.OFFLINE);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setTrimHeaters(Integer[] value) {
        trimHeaters = value;
    }

    public Integer[] getTrimHeaters() {
        return trimHeaters;
    }

    public void setTrimHeaterOpState(int heater, TrimHeaterOpState state) {
        trimHeaterOpState[heater] = state;
    }

    public TrimHeaterOpState getTrimHeaterOpState(int heater) {
        return trimHeaterOpState[heater];
    }

    public void setTrimHeaterState(int heater, TrimHeaterState state) {
        trimHeaterState[heater] = state;
    }

    public TrimHeaterState getTrimHeaterState(int heater) {
        return trimHeaterState[heater];
    }

    public void setTrimHeaterPower(int heater, double value) {
        trimHeaterPower[heater] = value;
    }

    public double getTrimHeaterPower(int heater) {
        return trimHeaterPower[heater];
    }

    public void setPlateTemperature(int heater, double value) {
        plateTemperature[heater] = value;
    }

    public double getPlateTemperature(int heater) {
        return plateTemperature[heater];
    }

    public void setAuxHeaters(Integer[] value) {
        auxHeaters = value;
    }

    public Integer[] getAuxHeaters() {
        return auxHeaters;
    }

    public void setAuxHeaterState(int heater, AuxHeaterState state) {
        auxHeaterState[heater] = state;
    }

    public AuxHeaterState getAuxHeaterState(int heater) {
        return auxHeaterState[heater];
    }

    public void setAuxHeaterPower(int heater, double value) {
        auxHeaterPower[heater] = value;
    }

    public double getAuxHeaterPower(int heater) {
        return auxHeaterPower[heater];
    }

    private static final long serialVersionUID = 6352997312547508508L;
}
