package org.lsst.ccs.subsystem.refrig.constants;

import java.util.LinkedHashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * Defines constants for the heat exchanger valves
 * 
 * @author saxton
 */
public class HexValves {

    public static final int
        VALVE_00L = 0,
        VALVE_00V = 1,
        VALVE_00R = 2,
        VALVE_01L = 3,
        VALVE_01V = 4,
        VALVE_01R = 5,
        VALVE_02L = 6,
        VALVE_02V = 7,
        VALVE_02R = 8,
        VALVE_13L = 9,
        VALVE_13V = 10,
        VALVE_13R = 11,
        VALVE_14L = 12,
        VALVE_14V = 13,
        VALVE_14R = 14,
        VALVE_15L = 15,
        VALVE_15V = 16,
        VALVE_15R = 17,
        NUM_VALVES = 18;

    public static final int
        HEX_0 = 0,
        HEX_1 = 1,
        NUM_HEXS = 2;

    public static final int
        CMPR_0 = 0,
        CMPR_1 = 1,
        CMPR_2 = 2,
        CMPR_3 = 3,
        CMPR_4 = 4,
        CMPR_5 = 5,
        NUM_CMPRS = 6;

    public static final Map<String, Integer> valveNameMap = new LinkedHashMap<>();
    static {
        valveNameMap.put("PVC1L", VALVE_00L);
        valveNameMap.put("PVC1V", VALVE_00V);
        valveNameMap.put("PVC1R", VALVE_00R);
        valveNameMap.put("PVC2L", VALVE_01L);
        valveNameMap.put("PVC2V", VALVE_01V);
        valveNameMap.put("PVC2R", VALVE_01R);
        valveNameMap.put("PVC3L", VALVE_02L);
        valveNameMap.put("PVC3V", VALVE_02V);
        valveNameMap.put("PVC3R", VALVE_02R);
        valveNameMap.put("PVC4L", VALVE_13L);
        valveNameMap.put("PVC4V", VALVE_13V);
        valveNameMap.put("PVC4R", VALVE_13R);
        valveNameMap.put("PVC5L", VALVE_14L);
        valveNameMap.put("PVC5V", VALVE_14V);
        valveNameMap.put("PVC5R", VALVE_14R);
        valveNameMap.put("PVC6L", VALVE_15L);
        valveNameMap.put("PVC6V", VALVE_15V);
        valveNameMap.put("PVC6R", VALVE_15R);
    }

    public static final Map<Integer, String> valveNumberMap = new LinkedHashMap<>();
    static {
        for (Map.Entry e : valveNameMap.entrySet()) {
            valveNumberMap.put((Integer)e.getValue(), (String)e.getKey());
        }
    }

    public static final Map<String, Integer> hxNameMap = new LinkedHashMap<>();
    static {
        hxNameMap.put("UpperHX", HEX_0);
        hxNameMap.put("LowerHX", HEX_1);
    }

    public static final Map<Integer, String> hxNumberMap = new LinkedHashMap<>();
    static {
        for (Map.Entry e : hxNameMap.entrySet()) {
            hxNumberMap.put((Integer)e.getValue(), (String)e.getKey());
        }
    }

    public static final Map<String, Integer> cmprNameMap = new LinkedHashMap<>();
    static {
        cmprNameMap.put("Cryo1", CMPR_0);
        cmprNameMap.put("Cryo2", CMPR_1);
        cmprNameMap.put("Cryo3", CMPR_2);
        cmprNameMap.put("Cryo4", CMPR_3);
        cmprNameMap.put("Cryo5", CMPR_4);
        cmprNameMap.put("Cryo6", CMPR_5);
    }

    public static final Map<Integer, String> cmprNumberMap = new LinkedHashMap<>();
    static {
        for (Map.Entry e : cmprNameMap.entrySet()) {
            cmprNumberMap.put((Integer)e.getValue(), (String)e.getKey());
        }
    }

    public static final Set<Integer>[] hxCmprSets = new Set[NUM_HEXS];
    static {
        hxCmprSets[HEX_0] = new LinkedHashSet<>();
        hxCmprSets[HEX_0].add(CMPR_0);
        hxCmprSets[HEX_0].add(CMPR_1);
        hxCmprSets[HEX_0].add(CMPR_2);
        hxCmprSets[HEX_1] = new LinkedHashSet<>();
        hxCmprSets[HEX_1].add(CMPR_3);
        hxCmprSets[HEX_1].add(CMPR_4);
        hxCmprSets[HEX_1].add(CMPR_5);
    }

    public static final Set<Integer>[] cmprValveSets = new Set[NUM_CMPRS];
    static {
        cmprValveSets[CMPR_0] = new LinkedHashSet<>();
        cmprValveSets[CMPR_0].add(VALVE_00L);
        cmprValveSets[CMPR_0].add(VALVE_00V);
        cmprValveSets[CMPR_0].add(VALVE_00R);
        cmprValveSets[CMPR_1] = new LinkedHashSet<>();
        cmprValveSets[CMPR_1].add(VALVE_01L);
        cmprValveSets[CMPR_1].add(VALVE_01V);
        cmprValveSets[CMPR_1].add(VALVE_01R);
        cmprValveSets[CMPR_2] = new LinkedHashSet<>();
        cmprValveSets[CMPR_2].add(VALVE_02L);
        cmprValveSets[CMPR_2].add(VALVE_02V);
        cmprValveSets[CMPR_2].add(VALVE_02R);
        cmprValveSets[CMPR_3] = new LinkedHashSet<>();
        cmprValveSets[CMPR_3].add(VALVE_13L);
        cmprValveSets[CMPR_3].add(VALVE_13V);
        cmprValveSets[CMPR_3].add(VALVE_13R);
        cmprValveSets[CMPR_4] = new LinkedHashSet<>();
        cmprValveSets[CMPR_4].add(VALVE_14L);
        cmprValveSets[CMPR_4].add(VALVE_14V);
        cmprValveSets[CMPR_4].add(VALVE_14R);
        cmprValveSets[CMPR_5] = new LinkedHashSet<>();
        cmprValveSets[CMPR_5].add(VALVE_15L);
        cmprValveSets[CMPR_5].add(VALVE_15V);
        cmprValveSets[CMPR_5].add(VALVE_15R);
    }

}
