package org.lsst.ccs.subsystem.refrig.data;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.subsystem.refrig.constants.CompConditions;
import org.lsst.ccs.subsystem.refrig.constants.CompLatches;
import org.lsst.ccs.subsystem.refrig.constants.CompSwConds;
import org.lsst.ccs.subsystem.refrig.constants.CompSwitches;
import org.lsst.ccs.subsystem.refrig.constants.CompTypes;

/**
 *  Contains the state of a cold compressor.
 *
 *  The order of the elements in each list determines the order they appear in the GUI
 *
 *  @author Owen Saxton
 */
public class ColdCompState extends CompState {

    public static final List<Integer> SWITCHES = new ArrayList<>();  // Determines presence & order in GUI
    static {
        SWITCHES.add(CompSwitches.SW_ENABLE);
        SWITCHES.add(CompSwitches.SW_ENABLE_ALERTS);
        SWITCHES.add(CompSwitches.SW_LIGHTS);
    }
    public static final List<Integer> LATCHES = new ArrayList<>();  // Determines presence & order in GUI
    static {
        LATCHES.add(CompLatches.LATCH_DISCHARGE_TEMP);
        LATCHES.add(CompLatches.LATCH_DISCHARGE_PRESS);
        LATCHES.add(CompLatches.LATCH_SUCTION_TEMP);
        LATCHES.add(CompLatches.LATCH_LIQUID_TEMP);
        LATCHES.add(CompLatches.LATCH_OIL_LEVEL);
        LATCHES.add(CompLatches.LATCH_POWER);
        LATCHES.add(CompLatches.LATCH_SENSORS_VALID);
        LATCHES.add(CompLatches.LATCH_SMOKE_DETC);
        LATCHES.add(CompLatches.LATCH_EXT_PERMIT);
    }
    public static final List<Integer> CONDITIONS = new ArrayList<>();  // Determines presence & order in GUI
    static {
        CONDITIONS.add(CompConditions.COND_KEYSWITCH_ON);
        CONDITIONS.add(CompConditions.COND_CMP_ENABLED);
        CONDITIONS.add(CompConditions.COND_CMP_WAITING);
        CONDITIONS.add(CompConditions.COND_CMP_POWERED);
        CONDITIONS.add(CompConditions.COND_DISC_TEMP_VALID);
        CONDITIONS.add(CompConditions.COND_DISC_PRESS_VALID);
        CONDITIONS.add(CompConditions.COND_SUCT_TEMP_VALID);
        CONDITIONS.add(CompConditions.COND_SUCT_PRESS_VALID);
        CONDITIONS.add(CompConditions.COND_LIQD_TEMP_VALID);
        CONDITIONS.add(CompConditions.COND_CURRENT_VALID);
        CONDITIONS.add(CompConditions.COND_VOLTAGE_VALID);
        CONDITIONS.add(CompConditions.COND_CURR_SENSOR_ERR);
        CONDITIONS.add(CompConditions.COND_LATCHES_CLEAR);
        CONDITIONS.add(CompConditions.COND_POWER_LED);
    }
    public static final List<Integer> SW_CONDITIONS = new ArrayList<>();  // Determines presence & order in GUI
    static {
        SW_CONDITIONS.add(CompSwConds.SWC_CMPR_POWER);
        SW_CONDITIONS.add(CompSwConds.SWC_DISC_PRESS);
        SW_CONDITIONS.add(CompSwConds.SWC_DISC_TEMP);
        SW_CONDITIONS.add(CompSwConds.SWC_SUCT_TEMP);
        SW_CONDITIONS.add(CompSwConds.SWC_PLATE_TEMP);
        SW_CONDITIONS.add(CompSwConds.SWC_LIQUID_TEMP);
    }

    public ColdCompState() {
        super(CompTypes.TYPE_COLD);
    }

    private static final long serialVersionUID = 1216381263116312937L;
}
