package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *  Contains the refrigeration state
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class RefrigState implements Serializable {
    
    public static final String KEY = "RefrigState";
    public static final int
        MAX_COLD_COMPRESSORS = 2,
        MAX_CRYO_COMPRESSORS = 6;

    private int tickMillis;           // Data status update period (ms)
    private int numColdComps;
    private int numCryoComps;
    private final List<CompState> coldState = new ArrayList<>();  // Cold compressor list
    private final List<CompState> cryoState = new ArrayList<>();  // Cryo compressor list
    
    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setNumColdComps(int value) {
        numColdComps = value;
    }

    public int getNumColdComps() {
        return numColdComps;
    }

    public void setNumCryoComps(int value) {
        numCryoComps = value;
    }

    public int getNumCryoComps() {
        return numCryoComps;
    }

    public void addColdState(CompState state) {
        coldState.add(state);
    }

    public List<CompState> getColdStates() {
        return coldState;
    }

    public CompState getColdState(int num) {
        return coldState.get(num);
    }

    public void addCryoState(CompState state) {
        cryoState.add(state);
    }

    public List<CompState> getCryoStates() {
        return cryoState;
    }

    public CompState getCryoState(int num) {
        return cryoState.get(num);
    }

    public void clearCompStates() {
        coldState.clear();
        cryoState.clear();
    }

    @Override
    public String toString() {
        return super.toString();  // Replace this
    }

    private static final long serialVersionUID = 4107717663109830598L;
}
