package org.lsst.ccs.subsystem.refrig.constants;

import java.util.HashSet;
import java.util.Set;

/**
 * Thermal system constants.
 * 
 * @author The LSST CCS Team
 */
public class ThermalConstants {

    public static final Set<AuxHeaterState> auxOnStates = new HashSet<>();
    static {
        auxOnStates.add(AuxHeaterState.ON);
        auxOnStates.add(AuxHeaterState.VOLTERR);
        auxOnStates.add(AuxHeaterState.CANTSET);
        auxOnStates.add(AuxHeaterState.NOLOAD);
    }
    public static final Set<TrimHeaterState> trimPowerStates = new HashSet<>();
    static {
        trimPowerStates.add(TrimHeaterState.POWER);
        trimPowerStates.add(TrimHeaterState.VOLTERR);
        trimPowerStates.add(TrimHeaterState.NOLOAD);
    }
    public static final Set<TrimHeaterState> trimTempStates = new HashSet<>();
    static {
        trimTempStates.add(TrimHeaterState.TEMP);
        trimTempStates.add(TrimHeaterState.VOLTERR_);
        trimTempStates.add(TrimHeaterState.NOLOAD_);
    }

}
