package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 *  Contains the state of the thermal system
 *
 *  @author Owen Saxton
 */
public class ThermalState implements Serializable {

    public static final String KEY = "ThermalState";

    public static final int
        POWER_OFF                = 0,
        POWER_ON                 = 1,
        POWER_TRIPPED            = 2,
        POWER_NONE               = 3,
        CONTROL_OFF              = 0,
        CONTROL_ON               = 1,
        CONTROL_AUTO             = 2,
        CONTROL_NONE             = 3,
        HEATER_COLD              = 0,
        HEATER_CRYO              = 1,
        NUM_HEATERS              = 2;

    private int systemState;        // Mask of state bits
    private int tickMillis;         // Data status update period (ms)
    private boolean alarmDisabled;
    private final int[] powerState = new int[NUM_HEATERS];         // Heater power state
    private final int[] controlState = new int[NUM_HEATERS];       // Heater control state
    private final double[] heaterPower = new double[NUM_HEATERS];  // Heater power set point
    private final double[] plateTemp = new double[NUM_HEATERS];    // Plate temperature set point

    void setSystemState(int state) {
        systemState = state;
    }

    int getSystemState() {
        return systemState;
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setAlarmDisabled(boolean value) {
        alarmDisabled = value;
    }

    public boolean isAlarmDisabled() {
        return alarmDisabled;
    }

    public void setHeaterPowerState(int heater, int state) {
        powerState[heater] = state;
    }

    public int getHeaterPowerState(int heater) {
        return powerState[heater];
    }

    public void setHeaterControlState(int heater, int state) {
        controlState[heater] = state;
    }

    public int getHeaterControlState(int heater) {
        return controlState[heater];
    }

    public void setHeaterPower(int heater, double value) {
        heaterPower[heater] = value;
    }

    public double getHeaterPower(int heater) {
        return heaterPower[heater];
    }

    public void setPlateTemp(int heater, double value) {
        plateTemp[heater] = value;
    }

    public double getPlateTemp(int heater) {
        return plateTemp[heater];
    }

    private static final long serialVersionUID = 9117713345059542384L;
}
